/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.data.recipe;

import com.feywild.feywild.data.DataUtils;
import com.feywild.feywild.item.ModItems;
import com.feywild.feywild.recipes.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.data.provider.recipe.RecipeExtension;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public interface AnvilExtension
extends RecipeExtension {
    default public void gemTransmutation(ItemLike input, ItemLike result, int mana) {
        this.anvil(result, 2).requires(input).requires(input).requires(input).requires(input).requires(input).schematics((ItemLike)ModItems.schematicsGemTransmutation).mana(mana).build();
    }

    default public AnvilRecipeBuilder anvil(ItemLike result) {
        return this.anvil(new ItemStack(result));
    }

    default public AnvilRecipeBuilder anvil(ItemLike result, int amount) {
        return this.anvil(new ItemStack(result, amount));
    }

    default public AnvilRecipeBuilder anvil(ItemStack result) {
        return new AnvilRecipeBuilder(this, result);
    }

    public static class AnvilRecipeBuilder {
        private final RecipeExtension ext;
        private final ItemStack result;
        private final List<Ingredient> inputs;
        @Nullable
        private Ingredient schematics;
        private int mana = -1;

        private AnvilRecipeBuilder(RecipeExtension ext, ItemStack result) {
            this.ext = ext;
            this.result = result;
            this.inputs = new ArrayList<Ingredient>();
        }

        public AnvilRecipeBuilder requires(ItemLike item) {
            return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public AnvilRecipeBuilder requires(Tag<Item> item) {
            return this.requires(Ingredient.m_43911_(item));
        }

        public AnvilRecipeBuilder requires(Ingredient item) {
            this.inputs.add(item);
            return this;
        }

        public AnvilRecipeBuilder schematics(ItemLike item) {
            return this.schematics(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public AnvilRecipeBuilder schematics(Tag<Item> item) {
            return this.schematics(Ingredient.m_43911_(item));
        }

        public AnvilRecipeBuilder schematics(Ingredient item) {
            if (this.schematics != null) {
                throw new IllegalStateException("Can't build dwarven anvil recipe with multiple schematics");
            }
            this.schematics = item;
            return this;
        }

        public AnvilRecipeBuilder mana(int mana) {
            if (this.mana >= 0) {
                throw new IllegalStateException("Mana can only set once per dwarven anvil recipe.");
            }
            this.mana = mana;
            return this;
        }

        public void build() {
            this.build(this.ext.provider().loc((ItemLike)this.result.m_41720_(), "dwarven_anvil"));
        }

        public void build(final ResourceLocation id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Can't build dwarven anvil recipe without inputs: " + id);
            }
            if (this.inputs.size() > 5) {
                throw new IllegalStateException("Can't build dwarven anvil recipe with more than 5 inputs: " + id);
            }
            if (this.mana < 0) {
                throw new IllegalStateException("mana not set for dwarven anvil recipe: " + id);
            }
            this.ext.consumer().accept(new FinishedRecipe(){

                public void m_7917_(@Nonnull JsonObject json) {
                    json.addProperty("mana", (Number)mana);
                    json.add("output", (JsonElement)DataUtils.serializeWithNbt(result));
                    if (schematics != null) {
                        json.add("schematics", schematics.m_43942_());
                    }
                    JsonArray inputList = new JsonArray();
                    inputs.forEach(i -> inputList.add(i.m_43942_()));
                    json.add("ingredients", (JsonElement)inputList);
                }

                @Nonnull
                public ResourceLocation m_6445_() {
                    return id;
                }

                @Nonnull
                public RecipeSerializer<?> m_6637_() {
                    return ModRecipeTypes.DWARVEN_ANVIL_SERIALIZER;
                }

                @Nullable
                public JsonObject m_5860_() {
                    return null;
                }

                @Nullable
                public ResourceLocation m_6448_() {
                    return null;
                }
            });
        }
    }
}

