/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity;

import com.feywild.feywild.entity.base.ITameable;
import com.feywild.feywild.entity.base.Trader;
import com.feywild.feywild.entity.goals.DwarvenAttackGoal;
import com.feywild.feywild.entity.goals.GoToAnvilPositionGoal;
import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.entity.goals.RefreshStockGoal;
import io.github.noeppi_noeppi.libx.util.NBTX;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DwarfBlacksmith
extends Trader
implements ITameable,
IAnimatable {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(DwarfBlacksmith.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    private BlockPos summonPos;
    private boolean isTamed;

    public DwarfBlacksmith(EntityType<? extends Trader> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    public static boolean canSpawn(EntityType<DwarfBlacksmith> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        if (pos.m_123342_() >= level.m_5736_() - 10 || level.m_45527_(pos) || random.nextDouble() < 0.15) {
            return false;
        }
        return DwarfBlacksmith.m_21400_(type, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    @Override
    public String getTradeCategory() {
        return this.isTamed() ? "tamed" : "untamed";
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    @Nonnull
    public InteractionResult m_7111_(Player player, @Nonnull Vec3 vec, @Nonnull InteractionHand hand) {
        if (!player.m_20193_().f_46443_) {
            this.trade(player);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected void trade(Player player) {
        this.m_7189_(player);
        this.m_45301_(player, (Component)new TranslatableComponent("Dwarven Trader"), 1);
        player.m_5661_((Component)new TranslatableComponent("dwarf.feywild.dialogue"), false);
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataNbt) {
        this.m_21446_(this.m_142538_(), 7);
        return super.m_6518_(level, difficulty, reason, spawnData, dataNbt);
    }

    public BlockPos getSummonPos() {
        return this.summonPos;
    }

    public void setSummonPos(BlockPos summonPos) {
        this.summonPos = summonPos.m_7949_();
    }

    @Override
    public boolean isTamed() {
        return this.isTamed;
    }

    public void setTamed(boolean tamed) {
        this.isTamed = tamed;
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.1f, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)GoToTargetPositionGoal.byBlockPos((Mob)this, this::getSummonPos, 5, 0.5f));
        this.f_21345_.m_25352_(2, (Goal)new GoToAnvilPositionGoal(this, this::getSummonPos, 5));
        this.f_21345_.m_25352_(6, (Goal)new RefreshStockGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DwarvenAttackGoal(this));
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Tamed", this.isTamed);
        if (this.summonPos != null) {
            NBTX.putPos((CompoundTag)nbt, (String)"SummonPos", (BlockPos)this.summonPos);
        }
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.isTamed = nbt.m_128471_("Tamed");
        this.summonPos = NBTX.getPos((CompoundTag)nbt, (String)"SummonPos", null);
    }

    public boolean m_5545_(@Nonnull LevelAccessor levelIn, @Nonnull MobSpawnType spawnReasonIn) {
        return super.m_5545_(levelIn, spawnReasonIn) && this.m_142538_().m_123342_() < 60 && !levelIn.m_45527_(this.m_142538_());
    }

    protected void m_8022_() {
        super.m_8022_();
        this.f_21345_.m_25360_(Goal.Flag.MOVE, true);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, true);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, true);
    }

    protected boolean m_7341_(@Nonnull Entity entityIn) {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @Nonnull DamageSource source) {
        return false;
    }

    protected int m_6552_(@Nonnull Player player) {
        return 0;
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return SoundEvents.f_12506_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12504_;
    }

    public float m_6100_() {
        return 0.6f;
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!this.f_20890_ && !this.m_21224_()) {
            if (this.getState() == State.ATTACKING) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.smash", Boolean.valueOf(false)));
                return PlayState.CONTINUE;
            }
            if (this.getState() == State.WORKING) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.craft", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dwarf_blacksmith.stand", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public boolean m_21532_() {
        return this.isTamed || this.m_7809_() > 0 || super.m_21532_();
    }

    public void m_6043_() {
        if (!this.m_21532_()) {
            Player entity = this.f_19853_.m_45930_((Entity)this, -1.0);
            Event.Result result = ForgeEventFactory.canEntityDespawn((Mob)this);
            if (result == Event.Result.DENY) {
                this.f_20891_ = 0;
                entity = null;
            } else if (result == Event.Result.ALLOW) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                entity = null;
            }
            if (entity != null) {
                double distance = entity.m_20280_((Entity)this);
                int k = this.m_6095_().m_20674_().m_21612_();
                int l = k * k;
                if (this.f_20891_ > 2400 && this.f_19796_.nextInt(800) == 0 && distance > (double)l && this.m_6785_(distance * 2.0)) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                } else if (distance < (double)l) {
                    this.f_20891_ = 0;
                }
            }
        } else {
            this.f_20891_ = 0;
        }
    }

    public static enum State {
        IDLE,
        ATTACKING,
        WORKING;

    }
}

