/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.quest.Alignment;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class FeyBase
extends PathfinderMob
implements IAnimatable {
    public final Alignment alignment;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    @Nullable
    protected UUID owner;

    protected FeyBase(EntityType<? extends PathfinderMob> entityType, Alignment alignment, Level level) {
        super(entityType, level);
        this.alignment = alignment;
        this.f_19811_ = true;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 4, true);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22280_, Attributes.f_22280_.m_22082_()).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22286_, 0.2);
    }

    @Nullable
    public Player getOwner() {
        return this.owner == null ? null : this.f_19853_.m_46003_(this.owner);
    }

    public void setOwner(@Nullable Player owner) {
        this.setOwner(owner == null ? null : owner.m_142081_());
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    @Nullable
    public abstract Vec3 getCurrentPointOfInterest();

    public abstract SimpleParticleType getParticle();

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(30, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new GoToTargetPositionGoal((Mob)this, this::getCurrentPointOfInterest, this.getMovementRange(), 1.5f));
        this.f_21345_.m_25352_(30, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(50, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
    }

    protected int getMovementRange() {
        return 6;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(11) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)this.getParticle(), this.m_20185_() + (Math.random() - 0.5), this.m_20186_() + 1.0 + (Math.random() - 0.5), this.m_20189_() + (Math.random() - 0.5), 0.0, -0.1, 0.0);
        }
    }

    public void m_7023_(@Nonnull Vec3 position) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, position);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, position);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            float slipperiness = 0.91f;
            if (this.f_19861_) {
                slipperiness = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            float groundMovementModifier = 0.16277137f / (slipperiness * slipperiness * slipperiness);
            slipperiness = 0.91f;
            if (this.f_19861_) {
                slipperiness = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.f_19861_ ? 0.1f * groundMovementModifier : 0.02f, position);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)slipperiness));
        }
        this.f_20923_ = this.f_20924_;
        double dx = this.m_20185_() - this.f_19854_;
        double dz = this.m_20189_() - this.f_19856_;
        float scaledLastHorizontalMotion = (float)Math.sqrt(dx * dx + dz * dz) * 4.0f;
        if (scaledLastHorizontalMotion > 1.0f) {
            scaledLastHorizontalMotion = 1.0f;
        }
        this.f_20924_ = (float)((double)this.f_20924_ + (double)(scaledLastHorizontalMotion - this.f_20924_) * 0.4);
        this.f_20925_ += this.f_20924_;
    }

    public boolean m_6147_() {
        return false;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @Nonnull DamageSource source) {
        return false;
    }

    protected int m_6552_(@Nonnull Player player) {
        return 0;
    }

    public boolean m_6573_(@Nonnull Player player) {
        return false;
    }

    protected boolean m_7341_(@Nonnull Entity entityIn) {
        return false;
    }

    public float m_6100_() {
        return 1.0f;
    }

    @Nonnull
    protected PathNavigation m_6037_(@Nonnull Level level) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double distanceSq) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return ModSoundEvents.pixieHurt;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSoundEvents.pixieDeath;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.f_19796_.nextBoolean() ? ModSoundEvents.pixieAmbient : null;
    }

    protected float m_6121_() {
        return 0.6f;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        }
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.owner = nbt.m_128403_("Owner") ? nbt.m_128342_("Owner") : null;
    }
}

