/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.base;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.entity.goals.GoToTargetPositionGoal;
import com.feywild.feywild.entity.goals.SingGoal;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.sound.ModSoundEvents;
import io.github.noeppi_noeppi.libx.util.NBTX;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Mandragora
extends PathfinderMob
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> CASTING = SynchedEntityData.m_135353_(Mandragora.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Mandragora.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private BlockPos summonPos;

    protected Mandragora(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22286_, 0.2);
    }

    public MandragoraVariant getVariation() {
        return MandragoraVariant.values()[(Integer)this.f_19804_.m_135370_(VARIANT)];
    }

    public BlockPos getSummonPos() {
        return this.summonPos;
    }

    public void setSummonPos(BlockPos summonPos) {
        this.summonPos = summonPos.m_7949_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(50, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.2f, 4.0f));
        this.f_21345_.m_25352_(2, (Goal)GoToTargetPositionGoal.byBlockPos((Mob)this, this::getSummonPos, 5, 0.2f));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_}), false));
        this.f_21345_.m_25352_(20, (Goal)new SingGoal(this));
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.summonPos != null) {
            NBTX.putPos((CompoundTag)nbt, (String)"SummonPos", (BlockPos)this.summonPos);
        }
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.summonPos = NBTX.getPos((CompoundTag)nbt, (String)"SummonPos", null);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CASTING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)VARIANT.m_135015_());
    }

    protected void m_8022_() {
        super.m_8022_();
        this.f_21345_.m_25360_(Goal.Flag.MOVE, true);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, true);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, true);
    }

    public boolean isCasting() {
        return (Boolean)this.f_19804_.m_135370_(CASTING);
    }

    public void setCasting(boolean casting) {
        this.f_19804_.m_135381_(CASTING, (Object)casting);
    }

    public boolean m_6147_() {
        return false;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @Nonnull DamageSource source) {
        return false;
    }

    protected int m_6552_(@Nonnull Player player) {
        return 0;
    }

    public boolean m_6573_(@Nonnull Player player) {
        return false;
    }

    protected boolean m_7341_(@Nonnull Entity entityIn) {
        return false;
    }

    public float m_6100_() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return ModSoundEvents.mandragoraHurt;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSoundEvents.mandragoraDeath;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return switch (this.f_19796_.nextInt(5)) {
            case 0 -> ModSoundEvents.mandragoraAmbience01;
            case 1 -> ModSoundEvents.mandragoraAmbience02;
            default -> null;
        };
    }

    @Nonnull
    public InteractionResult m_7111_(@Nonnull Player player, @Nonnull Vec3 hitVec, @Nonnull InteractionHand hand) {
        if (!(player.m_21120_(hand).m_41720_() != Items.f_42572_ || this.m_142581_() != null && this.m_142581_().m_6084_())) {
            if (!this.f_19853_.f_46443_) {
                this.m_5634_(4.0f);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                FeywildMod.getNetwork().sendParticles(this.f_19853_, ParticleSerializer.Type.FEY_HEART, this.m_20185_(), this.m_20186_(), this.m_20189_());
                player.m_21011_(hand, true);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_7111_(player, hitVec, hand);
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (this.isCasting() && !this.f_20890_ && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mandragora.sing", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mandragora.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.mandragora.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_21532_() {
        return true;
    }

    public static enum MandragoraVariant {
        MELON,
        ONION,
        POTATO,
        PUMPKIN,
        TOMATO;

    }
}

