/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import com.feywild.feywild.entity.DwarfBlacksmith;
import com.feywild.feywild.sound.ModSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class DwarvenAttackGoal
extends Goal {
    protected final DwarfBlacksmith entity;
    protected LivingEntity target;
    protected boolean sendShock = false;
    protected int ticksLeft = 0;

    public DwarvenAttackGoal(DwarfBlacksmith entity) {
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.entity.m_142581_() instanceof Monster) {
            this.target = this.entity.m_142581_();
            --this.ticksLeft;
            if (this.ticksLeft == 0) {
                this.reset();
            } else if (this.ticksLeft == 10) {
                this.sendShock = this.attackTarget();
                this.entity.m_5496_(ModSoundEvents.dwarfAttack, 1.0f, 1.2f);
                this.entity.setState(DwarfBlacksmith.State.IDLE);
            } else if (this.ticksLeft == 30) {
                this.entity.setState(DwarfBlacksmith.State.ATTACKING);
                this.entity.m_21573_().m_26519_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), 0.5);
            } else if (this.ticksLeft <= 30) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                if (this.sendShock) {
                    switch (this.ticksLeft) {
                        case 4: 
                        case 8: {
                            this.summonShockWave(true);
                            break;
                        }
                        case 6: {
                            this.summonShockWave(false);
                        }
                    }
                }
            }
        } else {
            this.reset();
        }
    }

    public void m_8056_() {
        this.ticksLeft = 70;
    }

    protected boolean attackTarget() {
        if (this.entity.m_21187_().nextDouble() > 0.6) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.entity), 15.0f);
            return false;
        }
        this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.entity), 20.0f);
        return true;
    }

    private void summonShockWave(boolean stage) {
        BlockPos centerPos = this.entity.m_142538_().m_7495_();
        int size = 2;
        ArrayList<FallingBlockEntity> entityList = new ArrayList<FallingBlockEntity>();
        for (int xd = 0; xd <= size; ++xd) {
            for (int zd = 0; zd <= size; ++zd) {
                int dist = Math.abs(xd) + Math.abs(zd);
                if (dist > size || this.entity.f_19853_.m_8055_(centerPos.m_142082_(xd, -1, zd)).m_60795_() || !this.entity.f_19853_.m_8055_(new BlockPos((Vec3i)centerPos.m_142082_(xd, 0, zd))).m_60795_() || xd == 0 && zd == 0) continue;
                if (stage) {
                    this.waveBlock(entityList, centerPos.m_142082_(xd, 0, zd));
                    this.waveBlock(entityList, centerPos.m_142082_(-xd, 0, -zd));
                    continue;
                }
                this.waveBlock(entityList, centerPos.m_142082_(xd, 0, -zd));
                this.waveBlock(entityList, centerPos.m_142082_(-xd, 0, zd));
            }
        }
        entityList.forEach(block -> {
            this.entity.m_5496_(ModSoundEvents.dwarfAttack, 1.0f, 1.0f);
            block.m_20334_(0.0, 0.3, 0.0);
            block.m_149656_(2.0f, 40);
            this.entity.f_19853_.m_7967_((Entity)block);
        });
    }

    private void waveBlock(List<FallingBlockEntity> entityList, BlockPos pos) {
        BlockState state = this.entity.f_19853_.m_8055_(pos);
        if (!state.m_155947_() && state.m_60800_((BlockGetter)this.entity.f_19853_, pos) >= 0.0f) {
            entityList.add(new FallingBlockEntity(this.entity.f_19853_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, state));
        }
    }

    protected void reset() {
        this.entity.setState(DwarfBlacksmith.State.IDLE);
        this.target = null;
        this.sendShock = false;
        this.ticksLeft = -1;
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0 && this.entity.m_142581_() instanceof Mob && !this.entity.m_142581_().m_20147_();
    }

    public boolean m_8036_() {
        return this.entity.m_142581_() instanceof Mob && !this.entity.m_142581_().m_20147_() && this.entity.m_142582_((Entity)this.entity.m_142581_());
    }
}

