/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.entity.goals;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class MovementRestrictionGoal
extends Goal {
    public final Supplier<Vec3> targetPosition;
    public final int maxMovementRangeSquared;

    public MovementRestrictionGoal(Supplier<Vec3> pos, int maxMovementRange) {
        this.targetPosition = pos;
        this.maxMovementRangeSquared = maxMovementRange * maxMovementRange;
    }

    public static double distanceFromSquared(Vec3 start, Vec3 end) {
        return (start.f_82479_ - end.f_82479_) * (start.f_82479_ - end.f_82479_) + (start.f_82480_ - end.f_82480_) * (start.f_82480_ - end.f_82480_) + (start.f_82481_ - end.f_82481_) * (start.f_82481_ - end.f_82481_);
    }

    public boolean isInRange(Vec3 pos) {
        Vec3 target = this.targetPosition.get();
        return target != null && MovementRestrictionGoal.distanceFromSquared(pos, target) <= (double)this.maxMovementRangeSquared;
    }

    public boolean m_8036_() {
        return false;
    }

    protected static Supplier<Vec3> asVector(Supplier<BlockPos> pos) {
        return () -> {
            BlockPos block = (BlockPos)pos.get();
            return block == null ? null : new Vec3((double)block.m_123341_() + 0.5, (double)block.m_123342_() + 0.5, (double)block.m_123343_() + 0.5);
        };
    }
}

