/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.jei;

import com.feywild.feywild.FeywildMod;
import com.feywild.feywild.block.ModBlocks;
import com.feywild.feywild.jei.AltarRecipeCategory;
import com.feywild.feywild.jei.DwarvenAnvilRecipeCategory;
import com.feywild.feywild.jei.TradeRecipeCategory;
import com.feywild.feywild.jei.util.FeywildJeiReloader;
import com.feywild.feywild.recipes.AltarRecipe;
import com.feywild.feywild.recipes.DwarvenAnvilRecipe;
import com.feywild.feywild.recipes.ModRecipeTypes;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class FeywildJei
implements IModPlugin {
    private static IJeiRuntime runtime;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(FeywildMod.getInstance().modid, "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new AltarRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new DwarvenAnvilRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new TradeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.feyAltar), new ResourceLocation[]{AltarRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.dwarvenAnvil), new ResourceLocation[]{DwarvenAnvilRecipeCategory.UID});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registration.addRecipes((Collection)rm.m_44013_(ModRecipeTypes.ALTAR).stream().filter(r -> r instanceof AltarRecipe).collect(Collectors.toList()), AltarRecipeCategory.UID);
        registration.addRecipes((Collection)rm.m_44013_(ModRecipeTypes.DWARVEN_ANVIL).stream().filter(r -> r instanceof DwarvenAnvilRecipe).collect(Collectors.toList()), DwarvenAnvilRecipeCategory.UID);
        registration.addRecipes(FeywildJeiReloader.clientTrades, TradeRecipeCategory.UID);
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime runtime) {
        FeywildJei.runtime = runtime;
    }

    public static void runtime(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }
}

