/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.network;

import com.feywild.feywild.network.OpenLibraryScreenHandler;
import com.feywild.feywild.network.OpenLibraryScreenSerializer;
import com.feywild.feywild.network.OpeningScreenHandler;
import com.feywild.feywild.network.OpeningScreenSerializer;
import com.feywild.feywild.network.ParticleHandler;
import com.feywild.feywild.network.ParticleSerializer;
import com.feywild.feywild.network.RequestItemHandler;
import com.feywild.feywild.network.RequestItemSerializer;
import com.feywild.feywild.network.TradesHandler;
import com.feywild.feywild.network.TradesSerializer;
import com.feywild.feywild.network.quest.ConfirmQuestHandler;
import com.feywild.feywild.network.quest.ConfirmQuestSerializer;
import com.feywild.feywild.network.quest.OpenQuestDisplayHandler;
import com.feywild.feywild.network.quest.OpenQuestDisplaySerializer;
import com.feywild.feywild.network.quest.OpenQuestSelectionHandler;
import com.feywild.feywild.network.quest.OpenQuestSelectionSerializer;
import com.feywild.feywild.network.quest.SelectQuestHandler;
import com.feywild.feywild.network.quest.SelectQuestSerializer;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class FeywildNetwork
extends NetworkX {
    public FeywildNetwork(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"5");
    }

    protected void registerPackets() {
        this.register(new OpenLibraryScreenSerializer(), () -> OpenLibraryScreenHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new RequestItemSerializer(), () -> RequestItemHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new ParticleSerializer(), () -> ParticleHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new TradesSerializer(), () -> TradesHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new OpeningScreenSerializer(), () -> OpeningScreenHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new OpenQuestSelectionSerializer(), () -> OpenQuestSelectionHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new OpenQuestDisplaySerializer(), () -> OpenQuestDisplayHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new SelectQuestSerializer(), () -> SelectQuestHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new ConfirmQuestSerializer(), () -> ConfirmQuestHandler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public void sendParticles(Level level, ParticleSerializer.Type type, BlockPos pos) {
        this.sendParticles(level, type, pos, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
    }

    public void sendParticles(Level level, ParticleSerializer.Type type, double x, double y, double z) {
        this.sendParticles(level, type, x, y, z, 0.0, 0.0, 0.0);
    }

    public void sendParticles(Level level, ParticleSerializer.Type type, double x, double y, double z, double vx, double vy, double vz) {
        BlockPos chunk = new BlockPos((int)x, (int)y, (int)z);
        this.sendParticles(level, type, chunk, x, y, z, vx, vy, vz);
    }

    private void sendParticles(Level level, ParticleSerializer.Type type, BlockPos chunk, double x, double y, double z, double vx, double vy, double vz) {
        if (level instanceof ServerLevel) {
            this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(chunk)), (Object)new ParticleSerializer.Message(type, x, y, z, vx, vy, vz));
        }
    }
}

