/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade;

import com.feywild.feywild.trade.TradeLevelData;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.trading.MerchantOffers;

public class TradeData {
    public static final TradeData EMPTY = new TradeData((List<TradeLevelData>)ImmutableList.of());
    private final List<TradeLevelData> levels;

    public TradeData(List<TradeLevelData> levels) {
        this.levels = ImmutableList.copyOf(levels);
    }

    public int getMaxLevel() {
        return this.levels.size();
    }

    public TradeLevelData getLevel(int level) {
        return this.levels.get(level - 1);
    }

    public VillagerData initialize(Entity merchant, VillagerData data, MerchantOffers offers, Random random) {
        if (this.getMaxLevel() >= 1) {
            this.getLevel(1).applyTo(merchant, offers, random);
            return new VillagerData(data.m_35560_(), data.m_35571_(), 1);
        }
        return data;
    }

    public VillagerData levelUp(Entity merchant, VillagerData data, MerchantOffers offers, Random random) {
        if (data.m_35576_() < this.getMaxLevel()) {
            this.getLevel(data.m_35576_() + 1).applyTo(merchant, offers, random);
            return new VillagerData(data.m_35560_(), data.m_35571_(), data.m_35576_() + 1);
        }
        return data;
    }

    public static TradeData fromJson(ResourceLocation id, JsonElement data) {
        ImmutableList.Builder levels = ImmutableList.builder();
        for (JsonElement elem : data.getAsJsonArray()) {
            levels.add((Object)TradeLevelData.fromJson(elem.getAsJsonObject()));
        }
        return new TradeData((List<TradeLevelData>)levels.build());
    }
}

