/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.trade;

import com.feywild.feywild.trade.TradeData;
import com.feywild.feywild.trade.recipe.TradeRecipe;
import com.feywild.feywild.trade.recipe.TradeRecipeManager;
import com.feywild.feywild.util.DatapackHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;

public class TradeManager {
    private static Map<ResourceLocation, TradeData> trades = ImmutableMap.of();
    private static List<TradeRecipe> cachedRecipes = null;

    public static TradeData getTrades(EntityType<?> type, String category) {
        if (type.getRegistryName() == null) {
            return TradeData.EMPTY;
        }
        ResourceLocation entityId = type.getRegistryName();
        ResourceLocation id = new ResourceLocation(entityId.m_135827_(), entityId.m_135815_() + "/" + category);
        return trades.getOrDefault(id, TradeData.EMPTY);
    }

    public static List<TradeRecipe> buildRecipes() {
        if (cachedRecipes == null) {
            ImmutableList.Builder recipes = ImmutableList.builder();
            for (Map.Entry<ResourceLocation, TradeData> entry : trades.entrySet()) {
                recipes.addAll(TradeRecipeManager.getRecipes(entry.getKey(), entry.getValue()));
            }
            cachedRecipes = recipes.build();
        }
        return cachedRecipes;
    }

    public static PreparableReloadListener createReloadListener() {
        return new SimplePreparableReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull ResourceManager rm, @Nonnull ProfilerFiller profiler) {
                return null;
            }

            protected void apply(@Nonnull Void value, @Nonnull ResourceManager rm, @Nonnull ProfilerFiller profiler) {
                trades = DatapackHelper.loadData(rm, "feywild_trades", TradeData::fromJson);
                cachedRecipes = null;
            }
        };
    }
}

