/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModList;

public class DatapackHelper {
    public static final Gson GSON = ((Supplier<Gson>)() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        return builder.create();
    }).get();

    public static <T> Map<ResourceLocation, T> loadData(ResourceManager rm, String path, BiFunction<ResourceLocation, JsonElement, T> factory) {
        try {
            ImmutableMap.Builder map = ImmutableMap.builder();
            Collection ids = rm.m_6540_(path, file -> file.endsWith(".json"));
            for (ResourceLocation id : ids) {
                String realPath = id.m_135815_();
                if (realPath.startsWith(path) && (realPath = realPath.substring(path.length())).startsWith("/")) {
                    realPath = realPath.substring(1);
                }
                if (realPath.endsWith(".json")) {
                    realPath = realPath.substring(0, realPath.length() - 5);
                }
                ResourceLocation realId = new ResourceLocation(id.m_135827_(), realPath);
                Resource resource = rm.m_142591_(id);
                InputStreamReader reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                map.put((Object)realId, factory.apply(realId, json));
            }
            return map.build();
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public static List<ItemStack> loadStackList(ResourceManager rm, String path, String name) {
        try {
            ImmutableList.Builder list = ImmutableList.builder();
            for (String namespace : rm.m_7187_()) {
                ResourceLocation id = new ResourceLocation(namespace, path + "/" + name + ".json");
                if (!rm.m_7165_(id)) continue;
                Resource resource = rm.m_142591_(id);
                InputStreamReader reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                for (JsonElement elem : json.getAsJsonArray()) {
                    if (elem.isJsonObject() && elem.getAsJsonObject().has("mod") && !ModList.get().isLoaded(elem.getAsJsonObject().get("mod").getAsString())) continue;
                    try {
                        list.add((Object)CraftingHelper.getItemStack((JsonObject)elem.getAsJsonObject(), (boolean)true));
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {}
                }
            }
            return list.build();
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

