/*
 * Decompiled with CFR 0.152.
 */
package com.feywild.feywild.world.dimension.market;

import com.feywild.feywild.FeyPlayerData;
import com.feywild.feywild.world.dimension.ModDimensions;
import com.feywild.feywild.world.dimension.SimpleTeleporter;
import com.feywild.feywild.world.dimension.market.MarketData;
import com.feywild.feywild.world.dimension.market.MarketGenerator;
import io.github.noeppi_noeppi.libx.util.NBTX;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;

public class MarketHandler {
    public static void update(MinecraftServer server) {
        MarketData data;
        ServerLevel market = server.m_129880_(ModDimensions.MARKET_PLACE_DIMENSION);
        if (market != null && (data = MarketData.get(market)) != null) {
            data.update(server, () -> market.m_8795_(player -> true).forEach(player -> {
                MarketHandler.teleportToOverworld(player);
                player.m_5661_((Component)new TranslatableComponent("message.feywild.market_closed"), false);
            }));
        }
    }

    public static boolean teleportToMarket(ServerPlayer player) {
        if (player.m_9236_().m_46472_() == Level.f_46428_) {
            MarketData data;
            ServerLevel targetLevel = player.m_9236_().m_142572_().m_129880_(ModDimensions.MARKET_PLACE_DIMENSION);
            if (targetLevel != null && (data = MarketData.get(targetLevel)) != null) {
                if (data.isOpen()) {
                    NBTX.putPos((CompoundTag)FeyPlayerData.get((Player)player), (String)"DwarfMarketPos", (BlockPos)player.m_142538_().m_7949_());
                    MarketGenerator.generate(targetLevel);
                    player.changeDimension(targetLevel, (ITeleporter)new SimpleTeleporter(new BlockPos(2, 61, 10)));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 63));
                    return true;
                }
                player.m_5661_((Component)new TranslatableComponent("message.feywild.market_closed"), false);
            }
        } else {
            player.m_5661_((Component)new TranslatableComponent("message.feywild.market_wrong_source"), false);
        }
        return false;
    }

    public static boolean teleportToOverworld(ServerPlayer player) {
        if (player.m_9236_().m_46472_() == ModDimensions.MARKET_PLACE_DIMENSION) {
            ServerLevel targetLevel = player.m_9236_().m_142572_().m_129783_();
            BlockPos targetPos = NBTX.getPos((CompoundTag)FeyPlayerData.get((Player)player), (String)"DwarfMarketPos", null);
            if (targetPos == null) {
                targetPos = player.m_8963_() == Level.f_46428_ & player.m_8961_() != null ? player.m_8961_() : targetLevel.m_8900_();
            }
            if (targetPos == null) {
                targetPos = new BlockPos(0, 64, 0);
            }
            player.changeDimension(targetLevel, (ITeleporter)new SimpleTeleporter(targetPos));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 63));
            return true;
        }
        return false;
    }
}

