/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec;

import io.github.noeppi_noeppi.libx.annotation.codec.Dynamic;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.FailureException;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModEnv;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.CodecType;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.GeneratedCodec;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.GetterSupplier;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.ParamType;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class DynamicType
implements CodecType {
    @Override
    public boolean matchesDirect(Element param, String name, ModEnv env) {
        return param.getAnnotation(Dynamic.class) != null;
    }

    @Override
    public boolean matches(Element param, String name, ModEnv env) {
        return this.matchesDirect(param, name, env);
    }

    @Override
    public GeneratedCodec.CodecElement generate(Element param, String name, GetterSupplier getter, ModEnv env) throws FailureException {
        String typeFqn = param.asType().toString();
        String typeFqnBoxed = env.boxed(param.asType()).toString();
        String factoryFqn = DynamicType.getFactoryFqn(param.asType(), param, env);
        return new GeneratedCodec.CodecDynamic(name, typeFqn, typeFqnBoxed, factoryFqn, getter.get());
    }

    private static String getFactoryFqn(TypeMirror type, Element paramElement, ModEnv env) {
        TypeMirror boxed = env.boxed(type);
        Dynamic annotation = paramElement.getAnnotation(Dynamic.class);
        if (annotation == null) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "No \u03a9Dynamic annotation", paramElement);
            throw new FailureException();
        }
        TypeMirror codecClass = env.classType(annotation::value);
        if (codecClass.getKind() == TypeKind.VOID) {
            codecClass = boxed;
        }
        String methodName = annotation.factory().isEmpty() ? "fieldOf" : annotation.factory();
        Element typeElem = env.types().asElement(codecClass);
        if (typeElem == null) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Not a valid type element: " + codecClass, paramElement);
            throw new FailureException();
        }
        ExecutableElement method = null;
        for (Element element : typeElem.getEnclosedElements()) {
            Element element2;
            if (element.getKind() != ElementKind.METHOD || !((element2 = element) instanceof ExecutableElement)) continue;
            ExecutableElement exec = (ExecutableElement)element2;
            if (!element.getSimpleName().contentEquals(methodName) || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !element.getModifiers().contains((Object)Modifier.STATIC) || !env.sameErasure(env.elements().getTypeElement("com.mojang.serialization.MapCodec").asType(), exec.getReturnType()) || exec.getParameters().size() != 1 || !env.sameErasure(env.forClass(String.class), exec.getParameters().get(0).asType())) continue;
            method = exec;
        }
        if (method == null) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, codecClass + "#" + methodName + " has invalid signature or can't be found.", paramElement);
            throw new FailureException();
        }
        if (!ParamType.genericMatches(method.getReturnType(), boxed, env)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, codecClass + "#" + methodName + " has invalid return type: Expected " + boxed + ", got " + method.getReturnType(), paramElement);
            throw new FailureException();
        }
        Element element = method.getEnclosingElement();
        if (!(element instanceof TypeElement)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Parent of dynamic codec factory is not a class.", paramElement);
            throw new FailureException();
        }
        TypeElement parent = (TypeElement)element;
        return parent.getQualifiedName().toString() + "." + method.getSimpleName().toString();
    }
}

