/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.base.tile;

import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.base.BlockBase;
import io.github.noeppi_noeppi.libx.base.tile.GameEventBlock;
import io.github.noeppi_noeppi.libx.base.tile.TickableBlock;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockBE<T extends BlockEntity>
extends BlockBase
implements EntityBlock {
    private final Class<T> beClass;
    private final Constructor<T> beConstructor;
    private final BlockEntityType<T> beType;

    public BlockBE(ModX mod, Class<T> beClass, BlockBehaviour.Properties properties) {
        this(mod, beClass, properties, new Item.Properties());
    }

    public BlockBE(ModX mod, Class<T> beClass, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.beClass = beClass;
        try {
            this.beConstructor = beClass.getConstructor(BlockEntityType.class, BlockPos.class, BlockState.class);
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            throw new RuntimeException("Could not get constructor for block entity " + beClass + ".", e);
        }
        this.beType = new BlockEntityType((pos, state) -> {
            try {
                return (BlockEntity)this.beConstructor.newInstance(this.getBlockEntityType(), pos, state);
            }
            catch (ReflectiveOperationException e) {
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                throw new RuntimeException("Could not create BlockEntity of type " + beClass + ".", e);
            }
        }, Set.of(this), null);
    }

    @Override
    public Set<Object> getAdditionalRegisters(ResourceLocation id) {
        return ImmutableSet.builder().addAll(super.getAdditionalRegisters(id)).add(this.beType).build();
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.beType.m_155264_(pos, state);
    }

    @Nullable
    public <X extends BlockEntity> BlockEntityTicker<X> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<X> beType) {
        if (this.beType.m_155262_(state) && TickableBlock.class.isAssignableFrom(this.beClass)) {
            return new BlockEntityTicker<X>(){

                public void m_155252_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull X blockEntity) {
                    Object x = blockEntity;
                    if (x instanceof TickableBlock) {
                        TickableBlock tickable = (TickableBlock)x;
                        tickable.tick();
                    }
                }
            };
        }
        return null;
    }

    @Nullable
    public <X extends BlockEntity> GameEventListener m_142226_(@Nonnull Level level, @Nonnull X blockEntity) {
        X x = blockEntity;
        if (x instanceof GameEventBlock) {
            GameEventBlock eventBlock = (GameEventBlock)x;
            BlockPositionSource source = new BlockPositionSource(blockEntity.m_58899_());
            return new GameEventListener(){
                final /* synthetic */ PositionSource val$source;
                final /* synthetic */ GameEventBlock val$eventBlock;
                {
                    this.val$source = positionSource;
                    this.val$eventBlock = gameEventBlock;
                }

                @Nonnull
                public PositionSource m_142460_() {
                    return this.val$source;
                }

                public int m_142078_() {
                    return this.val$eventBlock.gameEventRange();
                }

                public boolean m_142721_(@Nonnull Level level, @Nonnull GameEvent event, @Nullable Entity cause, @Nonnull BlockPos pos) {
                    return this.val$eventBlock.notifyGameEvent(event, cause);
                }
            };
        }
        return null;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!(level.f_46443_ || state.m_60713_(newState.m_60734_()) && newState.m_155947_() || !this.shouldDropInventory(level, pos, state) || (be = level.m_7702_(pos)) == null)) {
            be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                IItemHandler modifiable$temp = handler;
                if (modifiable$temp instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modifiable = (IItemHandlerModifiable)modifiable$temp;
                    for (int i = 0; i < modifiable.getSlots(); ++i) {
                        ItemStack stack = modifiable.getStackInSlot(i);
                        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, stack.m_41777_());
                        level.m_7967_((Entity)entity);
                        modifiable.setStackInSlot(i, ItemStack.f_41583_);
                    }
                }
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public T getBlockEntity(Level level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be == null || !this.beClass.isAssignableFrom(be.getClass())) {
            throw new IllegalStateException("Expected a block entity of type " + this.beClass + " at " + level + " " + pos + ", got" + be);
        }
        return (T)be;
    }

    public BlockEntityType<T> getBlockEntityType() {
        return this.beType;
    }

    protected boolean shouldDropInventory(Level level, BlockPos pos, BlockState state) {
        return true;
    }
}

