/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.config.ConfigValidator;
import io.github.noeppi_noeppi.libx.config.GenericValueMapper;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.event.ConfigLoadedEvent;
import io.github.noeppi_noeppi.libx.impl.config.ConfigImpl;
import io.github.noeppi_noeppi.libx.impl.config.ConfigState;
import io.github.noeppi_noeppi.libx.impl.config.ModMappers;
import io.github.noeppi_noeppi.libx.impl.network.ConfigShadowSerializer;
import io.github.noeppi_noeppi.libx.impl.network.NetworkImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class ConfigManager {
    private static final BiMap<ResourceLocation, Class<?>> configIds = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private static final Map<Class<?>, Path> configs = Collections.synchronizedMap(new HashMap());

    public static void registerValueMapper(String modid, ValueMapper<?, ?> mapper) {
        ModMappers.get(modid).registerValueMapper(mapper);
    }

    public static void registerValueMapper(String modid, GenericValueMapper<?, ?, ?> mapper) {
        ModMappers.get(modid).registerValueMapper(mapper);
    }

    public static void registerConfigValidator(String modid, ConfigValidator<?, ?> validator) {
        ModMappers.get(modid).registerConfigValidator(validator);
    }

    public static void registerConfig(String modid, Class<?> configClass, boolean clientConfig) {
        ConfigManager.registerConfig(new ResourceLocation(modid, "config"), configClass, clientConfig);
    }

    public static void registerConfig(ResourceLocation location, Class<?> configClass, boolean clientConfig) {
        if (configIds.containsKey((Object)location)) {
            throw new IllegalArgumentException("Config '" + location + "' is already bound to class " + configClass);
        }
        if (configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is already registered as '" + configIds.inverse().get(configClass) + "'");
        }
        Path path = ConfigImpl.resolveConfigPath(FMLPaths.GAMEDIR.get().resolve("config"), location);
        configIds.put((Object)location, configClass);
        configs.put(configClass, path);
        new ConfigImpl(location, configClass, path, clientConfig);
        ModMappers.get(location.m_135827_()).configRegistered();
        ConfigManager.firstLoadConfig(configClass);
    }

    public static void reloadAll() {
        for (Class<?> configClass : configs.keySet()) {
            ConfigManager.reloadConfig(configClass);
        }
    }

    private static void firstLoadConfig(Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is not registered as a config.");
        }
        try {
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)configIds.inverse().get(configClass));
            if (!config.clientConfig || FMLEnvironment.dist == Dist.CLIENT) {
                ConfigState defaultState = config.stateFromValues();
                config.setDefaultState(defaultState);
                ConfigState state = config.readFromFileOrCreateBy(defaultState);
                config.saveState(state);
                state.apply();
                MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(config.id, config.baseClass, ConfigLoadedEvent.LoadReason.INITIAL, config.clientConfig, config.path, config.path));
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            LibX.logger.error("Failed to load config '" + configIds.inverse().get(configClass) + "' (class: " + configClass + ")", e);
        }
    }

    public static void reloadConfig(Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is not registered as a config.");
        }
        try {
            ConfigImpl config = ConfigImpl.getConfig((ResourceLocation)configIds.inverse().get(configClass));
            if (!config.clientConfig || FMLEnvironment.dist == Dist.CLIENT) {
                ConfigState state = config.readFromFileOrCreateByDefault();
                config.saveState(state);
                if (!config.isShadowed()) {
                    state.apply();
                }
                config.reloadClientWorldState();
                MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(config.id, config.baseClass, ConfigLoadedEvent.LoadReason.RELOAD, config.clientConfig, config.path, config.path));
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            LibX.logger.error("Failed to reload config '" + configIds.inverse().get(configClass) + "' (class: " + configClass + ")", e);
        }
    }

    public static void forceResync(@Nullable ServerPlayer player, Class<?> configClass) {
        if (!configIds.containsValue(configClass)) {
            throw new IllegalArgumentException("Class " + configClass + " is not registered as a config.");
        }
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            ResourceLocation id = (ResourceLocation)configIds.inverse().get(configClass);
            ConfigImpl config = ConfigImpl.getConfig(id);
            if (!config.clientConfig && NetworkImpl.getImpl().canSend()) {
                PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
                NetworkImpl.getImpl().channel.send(target, (Object)new ConfigShadowSerializer.ConfigShadowMessage(config, config.cachedOrCurrent()));
            }
        } else {
            LibX.logger.error("ConfigManager.forceResync was called on a physical client. Ignoring.");
        }
    }

    public static void forceResync(@Nullable ServerPlayer player) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            for (ResourceLocation id : ConfigManager.configs()) {
                ConfigImpl config = ConfigImpl.getConfig(id);
                if (config.clientConfig || !NetworkImpl.getImpl().canSend()) continue;
                PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
                NetworkImpl.getImpl().channel.send(target, (Object)new ConfigShadowSerializer.ConfigShadowMessage(config, config.cachedOrCurrent()));
            }
        } else {
            LibX.logger.error("ConfigManager.forceResync was called on a physical client. Ignoring.");
        }
    }

    public static Set<ResourceLocation> configs() {
        return Collections.unmodifiableSet(configIds.keySet());
    }
}

