/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl;

import com.mojang.serialization.Codec;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ModInternal {
    private static final Object LOCK = new Object();
    private static final Map<Class<? extends ModX>, ModInternal> MAP = new HashMap<Class<? extends ModX>, ModInternal>();
    private final ModX mod;
    @Nullable
    private final Class<?> modInitClass;
    private final List<Runnable> setupTasks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ModX mod, FMLJavaModLoadingContext ctx) {
        Object object = LOCK;
        synchronized (object) {
            if (!Modifier.isFinal(mod.getClass().getModifiers())) {
                throw new IllegalStateException("Mod class must be final. Report to the author of the " + mod.modid + " mod.");
            }
            if (MAP.containsKey(mod.getClass())) {
                throw new IllegalStateException("ModInternal initialised twice for mod " + mod.getClass());
            }
            MAP.put(mod.getClass(), new ModInternal(mod, ctx));
        }
    }

    public static ModInternal get(ModX mod) {
        return ModInternal.get(mod.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModInternal get(Class<? extends ModX> modClass) {
        Object object = LOCK;
        synchronized (object) {
            if (!MAP.containsKey(modClass)) {
                throw new NoSuchElementException("ModInternal not found for mod " + modClass);
            }
            return MAP.get(modClass);
        }
    }

    private ModInternal(ModX mod, FMLJavaModLoadingContext ctx) {
        this.mod = mod;
        this.modInitClass = ClassUtil.forName(mod.getClass().getName() + "$");
        this.setupTasks = new ArrayList<Runnable>();
        ctx.getModEventBus().addListener(this::runSetup);
    }

    public void addSetupTask(Runnable task) {
        this.setupTasks.add(task);
    }

    public void callGeneratedCode() {
        if (this.modInitClass != null) {
            try {
                Method method = this.modInitClass.getDeclaredMethod("init", ModX.class);
                method.invoke(null, this.mod);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Generated code threw an exception for mod " + this.mod.modid, e.getTargetException());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to load generated code for mod " + this.mod.modid, e);
            }
        }
    }

    @Nullable
    public Map<Class<?>, Codec<?>> getCodecMap() {
        if (this.modInitClass != null) {
            try {
                return (Map)this.modInitClass.getField("codecs").get(null);
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Invalid generated code in " + this.modInitClass + ": Codec map not accessible", e);
            }
        }
        return null;
    }

    private void runSetup(FMLCommonSetupEvent event) {
        this.setupTasks.forEach(Runnable::run);
    }
}

