/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import io.github.noeppi_noeppi.libx.config.ConfigManager;
import io.github.noeppi_noeppi.libx.impl.config.ConfigImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ConfigEvents {
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void serverPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getPlayer().f_19853_.f_46443_ && (player = event.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                ConfigManager.forceResync(serverPlayer);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void clientPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_ && FMLEnvironment.dist == Dist.CLIENT) {
            for (ConfigImpl config : ConfigImpl.getAllConfigs()) {
                config.reloadClientWorldState();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clientPlayerLeave(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        for (ResourceLocation id : ConfigManager.configs()) {
            ConfigImpl config = ConfigImpl.getConfig(id);
            if (config.clientConfig) continue;
            config.restore();
        }
    }
}

