/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.mappers.generic;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.noeppi_noeppi.libx.config.GenericValueMapper;
import io.github.noeppi_noeppi.libx.config.ValidatorInfo;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.config.correct.ConfigCorrection;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.MapContent;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MapValueMapper<T>
implements GenericValueMapper<Map<String, T>, JsonObject, T> {
    public static final MapValueMapper<?> INSTANCE = new MapValueMapper();

    private MapValueMapper() {
    }

    @Override
    public Class<Map<String, T>> type() {
        return Map.class;
    }

    @Override
    public Class<JsonObject> element() {
        return JsonObject.class;
    }

    @Override
    public int getGenericElementPosition() {
        return 1;
    }

    @Override
    public Map<String, T> fromJson(JsonObject json, ValueMapper<T, JsonElement> mapper) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : json.entrySet()) {
            builder.put((Object)((String)entry.getKey()), mapper.fromJson((JsonElement)entry.getValue()));
        }
        return builder.build();
    }

    @Override
    public JsonObject toJson(Map<String, T> value, ValueMapper<T, JsonElement> mapper) {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, T> entry : value.entrySet()) {
            object.add(entry.getKey(), mapper.toJson(entry.getValue()));
        }
        return object;
    }

    @Override
    public Map<String, T> fromNetwork(FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        int size = buffer.m_130242_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)buffer.m_130136_(Short.MAX_VALUE), mapper.fromNetwork(buffer));
        }
        return builder.build();
    }

    @Override
    public void toNetwork(Map<String, T> value, FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        buffer.m_130130_(value.size());
        for (Map.Entry<String, T> entry : value.entrySet()) {
            buffer.m_130072_(entry.getKey(), Short.MAX_VALUE);
            mapper.toNetwork(entry.getValue(), buffer);
        }
    }

    @Override
    public Optional<Map<String, T>> correct(JsonElement json, ValueMapper<T, JsonElement> mapper, ConfigCorrection<Map<String, T>> correction) {
        if (json.isJsonObject()) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                correction.tryCorrect((JsonElement)entry.getValue(), mapper, value -> Optional.ofNullable(value.getOrDefault(entry.getKey(), null))).ifPresent(value -> map.put((Object)((String)entry.getKey()), value));
            }
            ImmutableMap result = map.build();
            if (result.isEmpty() && json.getAsJsonObject().size() > 0) {
                return Optional.empty();
            }
            return Optional.of(result);
        }
        if (json.isJsonArray() && json.getAsJsonArray().size() == 2 && (json.getAsJsonArray().get(0).isJsonPrimitive() || json.getAsJsonArray().get(0).isJsonNull())) {
            String key = json.getAsJsonArray().get(0).isJsonNull() ? "null" : json.getAsJsonArray().get(0).getAsString();
            Optional<Object> value2 = correction.tryCorrect(json.getAsJsonArray().get(1), mapper, ConfigCorrection.check(v -> v.size() == 1, v -> v.values().iterator().next()));
            return value2.map(t -> ImmutableMap.of((Object)key, (Object)t));
        }
        if (json.isJsonArray() && json.getAsJsonArray().size() == 0) {
            return Optional.of(ImmutableMap.of());
        }
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<Map<String, T>> createEditor(ValueMapper<T, JsonElement> mapper, ValidatorInfo<?> validator) {
        return ConfigEditor.custom(Map.of(), map -> new MapContent(map, mapper.createEditor(ValidatorInfo.empty())));
    }
}

