/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.forgespi.locating.IModFile;

public class LibXDatapack
extends AbstractPackResources {
    public static final String PREFIX = "libxdata";
    public static final int PACK_VERSION = 7;
    private final IModFile mod;
    private final String packId;
    private final byte[] packMcmeta;

    public LibXDatapack(IModFile mod, String packId) {
        super(new File("dummy"));
        this.mod = mod;
        this.packId = packId;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(bout);
            JsonObject packFile = new JsonObject();
            JsonObject packSection = new JsonObject();
            packSection.addProperty("description", "Dynamic Datapack: " + mod.getFileName() + "/" + packId);
            packSection.addProperty("pack_format", (Number)7);
            packFile.add("pack", (JsonElement)packSection);
            writer.write(packFile.toString() + "\n");
            ((Writer)writer).close();
            bout.close();
            this.packMcmeta = bout.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create dynamic datapack", e);
        }
    }

    @Nonnull
    public String m_8017_() {
        return this.mod.getFileName() + "/" + this.packId;
    }

    @Nonnull
    public Set<String> m_5698_(@Nonnull PackType type) {
        return switch (type) {
            case PackType.CLIENT_RESOURCES -> {
                Set<String> var2_2;
                yield var2_2 = Set.of();
            }
            case PackType.SERVER_DATA -> {
                Path root = this.mod.findResource(new String[]{PREFIX, this.packId});
                if (!Files.exists(root, new LinkOption[0])) {
                    Set var2_3 = Set.of();
                    yield var2_3;
                }
                try {
                    Set<String> var2_4 = Set.copyOf(Files.list(root).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(root::relativize).filter(p -> p.getNameCount() == 1).map(Path::getFileName).map(Path::toString).toList());
                    yield var2_4;
                }
                catch (IOException e) {
                    Set var2_5 = Set.of();
                    yield var2_5;
                }
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    protected boolean m_6105_(@Nonnull String name) {
        return name.equals("pack.mcmeta") || Files.exists(this.mod.findResource(new String[]{PREFIX, this.packId, name}), new LinkOption[0]);
    }

    public boolean m_7211_(@Nonnull PackType type, @Nonnull ResourceLocation location) {
        return switch (type) {
            case PackType.CLIENT_RESOURCES -> false;
            case PackType.SERVER_DATA -> this.m_6105_(location.m_135827_() + "/" + location.m_135815_());
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Nonnull
    protected InputStream m_5541_(@Nonnull String name) throws IOException {
        if (name.equals("pack.mcmeta")) {
            return new ByteArrayInputStream(this.packMcmeta);
        }
        Path path = this.mod.findResource(new String[]{PREFIX, this.packId, name});
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Resource " + name + " not found in dynamic datapack " + this.m_8017_());
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    @Nonnull
    public InputStream m_8031_(@Nonnull PackType type, @Nonnull ResourceLocation location) throws IOException {
        switch (type) {
            case CLIENT_RESOURCES: {
                throw new FileNotFoundException("Dynamic datapack can't contain client resources: " + location + " not found in " + this.m_8017_());
            }
            case SERVER_DATA: {
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return this.m_5541_(location.m_135827_() + "/" + location.m_135815_());
    }

    @Nonnull
    public Collection<ResourceLocation> m_7466_(@Nonnull PackType type, @Nonnull String namespace, @Nonnull String path, int maxDepth, @Nonnull Predicate<String> filter) {
        return switch (type) {
            case PackType.CLIENT_RESOURCES -> {
                Set<ResourceLocation> var6_6;
                yield var6_6 = Set.of();
            }
            case PackType.SERVER_DATA -> {
                Path root = this.mod.findResource(new String[]{PREFIX, this.packId});
                try {
                    Set var6_7 = Set.copyOf(Files.walk(root, maxDepth + 1, new FileVisitOption[0]).map(root::relativize).map(Path::normalize).filter(p -> p.getNameCount() > 1 && p.getNameCount() + 1 <= maxDepth).filter(p -> p.getName(0).toString().equals(namespace)).filter(p -> p.startsWith(path)).flatMap(p -> this.resourcePath(namespace, (Path)p)).toList());
                    yield var6_7;
                }
                catch (IOException e) {
                    Set var6_8 = Set.of();
                    yield var6_8;
                }
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private Stream<ResourceLocation> resourcePath(String namespace, Path path) {
        Path p = path.subpath(1, path.getNameCount());
        String pathStr = IntStream.range(0, p.getNameCount()).mapToObj(idx -> p.getName(idx).toString()).collect(Collectors.joining("/"));
        if (ResourceLocation.m_135841_((String)pathStr)) {
            return Stream.of(new ResourceLocation(namespace, pathStr));
        }
        return Stream.empty();
    }

    public void close() {
    }

    public boolean isHidden() {
        return true;
    }
}

