/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.noeppi_noeppi.libx.impl.render.BlockOverlayQuadCache;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RenderHelperBlock {
    private static final RenderType RENDER_TYPE_BREAK = RenderType.m_110494_((ResourceLocation)InventoryMenu.f_39692_);
    private static final Random random = new Random();

    public static void renderBlockBreak(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, int breakProgress) {
        RenderHelperBlock.renderBlockBreak(state, poseStack, buffer, light, overlay, breakProgress, state.m_60726_(BlockPos.f_121853_));
    }

    public static void renderBlockBreak(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, int breakProgress, long positionRandom) {
        if (breakProgress > 0) {
            ResourceLocation tex = (ResourceLocation)ModelBakery.f_119227_.get((breakProgress - 1) % ModelBakery.f_119227_.size());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(tex);
            RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, buffer, light, overlay, sprite, positionRandom);
        }
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, TextureAtlasSprite sprite) {
        RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, buffer, light, overlay, sprite, state.m_60726_(BlockPos.f_121853_));
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, TextureAtlasSprite sprite, long positionRandom) {
        RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, buffer, light, overlay, sprite, positionRandom, dir -> true);
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, TextureAtlasSprite sprite, Predicate<Direction> dirs) {
        RenderHelperBlock.renderBlockOverlaySprite(state, poseStack, buffer, light, overlay, sprite, state.m_60726_(BlockPos.f_121853_), dirs);
    }

    public static void renderBlockOverlaySprite(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, TextureAtlasSprite sprite, long positionRandom, Predicate<Direction> dirs) {
        if (state.m_60799_() == RenderShape.MODEL) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
            VertexConsumer vertex = Minecraft.m_91087_().m_91269_().m_110108_().m_6299_(RENDER_TYPE_BREAK);
            for (Direction direction : Direction.values()) {
                random.setSeed(positionRandom);
                List list = model.getQuads(state, direction, random, (IModelData)EmptyModelData.INSTANCE);
                if (list.isEmpty()) continue;
                RenderHelperBlock.renderBlockOverlayQuad(DefaultVertexFormat.f_85811_, poseStack.m_85850_(), vertex, list, light, overlay, sprite, dirs);
            }
            random.setSeed(positionRandom);
            List list = model.getQuads(state, null, random, (IModelData)EmptyModelData.INSTANCE);
            if (!list.isEmpty()) {
                RenderHelperBlock.renderBlockOverlayQuad(DefaultVertexFormat.f_85811_, poseStack.m_85850_(), vertex, list, light, overlay, sprite, dirs);
            }
        }
    }

    private static void renderBlockOverlayQuad(VertexFormat format, PoseStack.Pose pose, VertexConsumer vertex, List<BakedQuad> list, int light, int overlay, TextureAtlasSprite sprite, Predicate<Direction> dirs) {
        for (BakedQuad quad : list) {
            if (!dirs.test(quad.m_111306_())) continue;
            vertex.m_85987_(pose, RenderHelperBlock.modifyBlockQuad(format, quad, sprite), 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    private static BakedQuad modifyBlockQuad(VertexFormat format, BakedQuad quad, TextureAtlasSprite newSprite) {
        BakedQuad result = BlockOverlayQuadCache.get(quad, newSprite);
        if (result == null) {
            int[] data = quad.m_111303_();
            int[] newData = new int[data.length];
            System.arraycopy(data, 0, newData, 0, data.length);
            int uvIdx = format.m_86023_().indexOf((Object)DefaultVertexFormat.f_166849_);
            if (uvIdx != -1) {
                TextureAtlasSprite oldSprite = quad.m_173410_();
                int uvOff = format.getOffset(uvIdx) / 4;
                int intSize = format.m_86017_();
                int off = 0;
                while (off + uvOff + 1 < newData.length) {
                    newData[off + uvOff] = Float.floatToRawIntBits((Float.intBitsToFloat(data[off + uvOff]) - oldSprite.m_118409_()) * (float)newSprite.m_118405_() / (float)oldSprite.m_118405_() + newSprite.m_118409_());
                    newData[off + uvOff + 1] = Float.floatToRawIntBits((Float.intBitsToFloat(data[off + uvOff + 1]) - oldSprite.m_118411_()) * (float)newSprite.m_118408_() / (float)oldSprite.m_118408_() + newSprite.m_118411_());
                    off += intSize;
                }
            }
            result = new BakedQuad(newData, quad.m_111305_(), quad.m_111306_(), newSprite, quad.m_111307_());
            BlockOverlayQuadCache.put(quad, result);
        }
        return result;
    }
}

