/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider.texture;

import io.github.noeppi_noeppi.libx.data.provider.texture.Textures;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class ImageHelper {
    public static void copyTexture(BufferedImage image, Textures textures, String src, int x, int y, int width, int height, int u, int v) {
        ImageHelper.doCopyImage(image, textures, textures.texture(src), textures.textureScale(src), x, y, width, height, u, v);
    }

    public static void copyImage(BufferedImage image, Textures textures, String src, int x, int y, int width, int height, int u, int v) {
        ImageHelper.doCopyImage(image, textures, textures.image(src), textures.imageScale(src), x, y, width, height, u, v);
    }

    public static void copyTexture(BufferedImage image, Textures textures, ResourceLocation src, int x, int y, int width, int height, int u, int v) {
        ImageHelper.doCopyImage(image, textures, textures.texture(src), textures.textureScale(src), x, y, width, height, u, v);
    }

    public static void copyImage(BufferedImage image, Textures textures, ResourceLocation src, int x, int y, int width, int height, int u, int v) {
        ImageHelper.doCopyImage(image, textures, textures.image(src), textures.imageScale(src), x, y, width, height, u, v);
    }

    private static void doCopyImage(BufferedImage image, Textures textures, BufferedImage src, int srcScale, int x, int y, int width, int height, int u, int v) {
        ImageHelper.doCopyImage(image, src, x * textures.scale(), y * textures.scale(), width * textures.scale(), height * textures.scale(), u * srcScale, v * srcScale, width * srcScale, height * srcScale);
    }

    private static void doCopyImage(BufferedImage image, BufferedImage src, int x, int y, int width, int height, int u, int v, int uw, int vh) {
        ImageHelper.observer().waitFor(o -> image.getGraphics().drawImage(src, x, y, x + width, y + height, u, v, u + uw, v + vh, (ImageObserver)o));
    }

    public static void clear(BufferedImage image, Textures textures, int x, int y, int width, int height) {
        int[] data = new int[width * textures.scale() * (height * textures.scale())];
        image.setRGB(x * textures.scale(), y * textures.scale(), width * textures.scale(), height * textures.scale(), data, 0, width * textures.scale());
    }

    private static WaitingObserver observer() {
        return new WaitingObserver("");
    }

    private static class WaitingObserver
    implements ImageObserver {
        private final Object lock = new Object();
        private final String description;
        private boolean success = false;
        private RuntimeException ex = null;

        private WaitingObserver(String description) {
            this.description = description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.success && this.ex == null) {
                    if ((flags & 0x80) != 0) {
                        this.ex = new IllegalStateException("Image operation aborted");
                        this.lock.notifyAll();
                        return false;
                    }
                    if ((flags & 0x40) != 0) {
                        this.ex = new IllegalStateException("Image operation failed");
                        this.lock.notifyAll();
                        return false;
                    }
                    if ((flags & 0x20) != 0 || (flags & 0x10) != 0) {
                        this.success = true;
                        this.notifyAll();
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }

        public void waitFor(Function<ImageObserver, Boolean> instantSuccess) {
            if (!instantSuccess.apply(this).booleanValue()) {
                this.waitFor();
            }
        }

        public void waitFor() {
            Object object = this.lock;
            synchronized (object) {
                if (this.success) {
                    return;
                }
                if (this.ex != null) {
                    throw new RuntimeException("Waiting for image " + this.description + " failed", this.ex);
                }
                while (true) {
                    try {
                        do {
                            this.lock.wait();
                            if (!this.success) continue;
                            return;
                        } while (this.ex == null);
                        throw new RuntimeException("Waiting for image " + this.description + " failed", this.ex);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

