/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider.texture;

import io.github.noeppi_noeppi.libx.data.provider.texture.TextureBuilder;
import io.github.noeppi_noeppi.libx.data.provider.texture.TextureFactory;
import io.github.noeppi_noeppi.libx.data.provider.texture.Textures;
import io.github.noeppi_noeppi.libx.impl.data.texture.SignTextureFactory;
import io.github.noeppi_noeppi.libx.impl.data.texture.TextureGenerator;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class TextureProviderBase
implements DataProvider {
    private final ModX mod;
    private final TextureGenerator generator;
    private final Map<ResourceLocation, TextureFactory> textures;

    protected TextureProviderBase(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        this.mod = mod;
        this.generator = new TextureGenerator(mod.modid, generator, fileHelper);
        this.textures = new HashMap<ResourceLocation, TextureFactory>();
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " textures.";
    }

    public abstract void setup();

    public void texture(String loc, TextureFactory factory) {
        this.texture(this.mod.resource(loc), factory);
    }

    public void image(String loc, TextureFactory factory) {
        this.image(this.mod.resource(loc), factory);
    }

    public void texture(ResourceLocation loc, TextureFactory factory) {
        this.image(new ResourceLocation(loc.m_135827_(), "textures/" + loc.m_135815_() + ".png"), factory);
    }

    public void image(ResourceLocation loc, TextureFactory factory) {
        this.textures.put(loc, factory);
    }

    public void sign(WoodType wood, ResourceLocation log, ResourceLocation planks) {
        ResourceLocation woodId = new ResourceLocation(wood.m_61846_());
        this.sign(new ResourceLocation(woodId.m_135827_(), "entity/signs/" + woodId.m_135815_()), log, planks);
    }

    public void sign(ResourceLocation signTexture, ResourceLocation log, ResourceLocation planks) {
        this.texture(signTexture, (TextureFactory)new SignTextureFactory(log, planks));
    }

    public void m_6865_(@Nonnull HashCache cache) throws IOException {
        this.setup();
        for (Map.Entry<ResourceLocation, TextureFactory> entry : this.textures.entrySet()) {
            ResourceLocation id = entry.getKey();
            TextureFactory factory = entry.getValue();
            TextureBuilder builder = new TextureBuilder(this.mod, this.generator::loadImage);
            factory.addTextures(builder);
            Textures textures = builder.build();
            Dimension dim = factory.getSize();
            BufferedImage image = this.generator.newImage(dim.width, dim.height, textures.scale());
            factory.generate(image, textures);
            this.generator.save(cache, id, image);
        }
    }
}

