/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.commands;

import com.google.common.collect.Streams;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModListCommand
implements Command<CommandSourceStack> {
    private static final HoverEvent COPY_MODLIST = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("libx.misc.copy_modlist"));
    public final boolean detailed;

    public ModListCommand(boolean detailed) {
        this.detailed = detailed;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Stream<MutableComponent> lineStream = ModList.get().getMods().stream().sorted(Comparator.comparing(IModInfo::getDisplayName)).filter(mod -> !mod.getModId().equalsIgnoreCase("minecraft")).map(mod -> mod.getDisplayName() + mod.getConfig().getConfigElement(new String[]{"authors"}).map(a -> " (by " + a.toString().trim() + ")").orElse("") + (String)(this.detailed && !mod.getDescription().trim().isEmpty() ? ": " + mod.getDescription().split("\n")[0].trim() : "")).map(TextComponent::new);
        List lines = Streams.mapWithIndex(lineStream, (line, idx) -> line.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)(idx % 2L == 0L ? 0xFFFF00 : 0xFF00F6))))).map(line -> line.m_130948_(Style.f_131099_.m_131144_(COPY_MODLIST))).collect(Collectors.toList());
        String copyToClipboard = lines.stream().map(Component::getString).collect(Collectors.joining("\n"));
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copyToClipboard);
        lines.stream().map(line -> line.m_130948_(Style.f_131099_.m_131142_(clickEvent))).forEach(line -> ((CommandSourceStack)context.getSource()).m_81354_((Component)line, false));
        return 0;
    }
}

