/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.gui.screen.content;

import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.config.gui.ConfigScreenContent;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.impl.config.gui.EditorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.tuple.Pair;

public class MapContent<T>
implements ConfigScreenContent<Map<String, T>> {
    private final ConfigEditor<T> editor;
    private Consumer<Map<String, T>> inputChanged;
    private final List<Pair<String, T>> list;
    private final List<AbstractWidget> widgets;

    public MapContent(Map<String, T> value, ConfigEditor<T> editor) {
        this.editor = editor;
        this.list = new ArrayList(value.entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), e.getValue())).sorted(Map.Entry.comparingByKey()).toList());
        this.widgets = new ArrayList<AbstractWidget>(IntStream.range(0, this.list.size()).mapToObj(i -> null).toList());
    }

    @Override
    public Component title() {
        return new TranslatableComponent("libx.config.gui.map.title");
    }

    @Override
    public boolean searchable() {
        return false;
    }

    @Override
    public void init(Consumer<Map<String, T>> inputChanged) {
        this.inputChanged = inputChanged;
    }

    private void update() {
        if (this.inputChanged != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Pair<String, T> entry : this.list) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            this.inputChanged.accept((Map<String, ImmutableMap>)ImmutableMap.copyOf(map));
        }
    }

    @Override
    public void buildGui(Screen screen, final ConfigScreenContent.ScreenManager manager, String search, Consumer<AbstractWidget> consumer) {
        int y = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            this.addEntryWidgets(screen, manager, consumer, i, y);
            y += 23;
        }
        Button button = new Button(3, y, 100, 20, (Component)new TranslatableComponent("libx.config.gui.map.new"), b -> {}){

            public void m_5691_() {
                MapContent.this.list.add(Pair.of((Object)"", MapContent.this.editor.defaultValue()));
                MapContent.this.widgets.add(null);
                MapContent.this.update();
                manager.rebuild();
            }
        };
        consumer.accept((AbstractWidget)button);
    }

    private void addEntryWidgets(Screen screen, final ConfigScreenContent.ScreenManager manager, Consumer<AbstractWidget> consumer, final int idx, int y) {
        int width = Math.min(200, (screen.f_96543_ - 64) / 2);
        AtomicReference<String> current = new AtomicReference<String>((String)this.list.get(idx).getKey());
        EditBox keyInput = new EditBox(Minecraft.m_91087_().f_91062_, 3, y, width, 20, (Component)new TextComponent(""));
        keyInput.m_94199_(Short.MAX_VALUE);
        keyInput.m_94144_(current.get());
        keyInput.m_94151_(str -> {
            if (!((String)current.get()).equals(str)) {
                current.set((String)str);
                this.list.set(idx, Pair.of((Object)str, (Object)this.list.get(idx).getValue()));
                this.update();
            }
        });
        consumer.accept((AbstractWidget)keyInput);
        WidgetProperties<Object> properties = new WidgetProperties<Object>(screen.f_96543_ - 31 - width, y, width, 20, t -> {
            this.list.set(idx, Pair.of((Object)((String)this.list.get(idx).getKey()), (Object)t));
            this.update();
        });
        AbstractWidget widget = EditorHelper.create(screen, this.editor, this.list.get(idx).getValue(), this.widgets.get(idx), properties);
        this.widgets.set(idx, widget);
        consumer.accept(widget);
        Button deleteEntryButton = new Button(screen.f_96543_ - 28, y, 20, 20, (Component)new TextComponent("\u2716").m_130940_(ChatFormatting.RED), b -> {}){

            public void m_5691_() {
                MapContent.this.list.remove(idx);
                MapContent.this.widgets.remove(idx);
                MapContent.this.update();
                manager.rebuild();
            }
        };
        consumer.accept((AbstractWidget)deleteEntryButton);
    }
}

