/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.mappers.generic;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import io.github.noeppi_noeppi.libx.config.GenericValueMapper;
import io.github.noeppi_noeppi.libx.config.ValidatorInfo;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.config.correct.ConfigCorrection;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public class OptionValueMapper<T>
implements GenericValueMapper<Optional<T>, JsonElement, T> {
    public static final OptionValueMapper<?> INSTANCE = new OptionValueMapper();

    private OptionValueMapper() {
    }

    @Override
    public Class<Optional<T>> type() {
        return Optional.class;
    }

    @Override
    public Class<JsonElement> element() {
        return JsonElement.class;
    }

    @Override
    public int getGenericElementPosition() {
        return 0;
    }

    @Override
    public Optional<T> fromJson(JsonElement json, ValueMapper<T, JsonElement> mapper) {
        if (json.isJsonNull()) {
            return Optional.empty();
        }
        return Optional.of(mapper.fromJson(json));
    }

    @Override
    public JsonElement toJson(Optional<T> value, ValueMapper<T, JsonElement> mapper) {
        if (value.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        return mapper.toJson(value.get());
    }

    @Override
    public Optional<T> fromNetwork(FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        if (!buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(mapper.fromNetwork(buffer));
    }

    @Override
    public void toNetwork(Optional<T> value, FriendlyByteBuf buffer, ValueMapper<T, JsonElement> mapper) {
        if (value.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            mapper.toNetwork(value.get(), buffer);
        }
    }

    @Override
    public Optional<Optional<T>> correct(JsonElement json, ValueMapper<T, JsonElement> mapper, ConfigCorrection<Optional<T>> correction) {
        return correction.tryCorrect(json, mapper, Function.identity()).map(Optional::of);
    }

    @Override
    public ConfigEditor<Optional<T>> createEditor(ValueMapper<T, JsonElement> mapper, ValidatorInfo<?> validator) {
        return ConfigEditor.option(mapper.createEditor(ValidatorInfo.empty()));
    }
}

