/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.menu;

import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.impl.menu.GenericContainerSlotValidationWrapper;
import io.github.noeppi_noeppi.libx.menu.MenuBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class GenericMenu
extends MenuBase {
    private static final ResourceLocation EMPTY_VALIDATOR = new ResourceLocation(LibX.getInstance().modid, "nothing");
    private static final Map<ResourceLocation, BiPredicate<Integer, ItemStack>> validators = new HashMap<ResourceLocation, BiPredicate<Integer, ItemStack>>(Map.of(EMPTY_VALIDATOR, (slot, stack) -> true));
    public static final MenuType<GenericMenu> TYPE = IForgeContainerType.create((id, playerInv, buffer) -> {
        BiPredicate<Integer, ItemStack> validator;
        int size = buffer.m_130242_();
        ResourceLocation validatorId = buffer.m_130281_();
        if (validators.containsKey(validatorId)) {
            validator = validators.get(validatorId);
        } else {
            LibX.logger.warn("Received invalid validator for generic container. Validator: " + validatorId);
            validator = validators.get(EMPTY_VALIDATOR);
        }
        int[] slotLimits = new int[size];
        for (int i = 0; i < size; ++i) {
            slotLimits[i] = buffer.m_130242_();
        }
        GenericContainerSlotValidationWrapper handler = new GenericContainerSlotValidationWrapper((IItemHandlerModifiable)new ItemStackHandler(size), validator, slotLimits);
        return new GenericMenu(id, handler, playerInv);
    });
    public final int width;
    public final int height;
    public final int invX;
    public final int invY;
    public final List<Pair<Integer, Integer>> slotList;

    private GenericMenu(int id, IItemHandlerModifiable handler, Inventory playerContainer) {
        super(TYPE, id, playerContainer);
        Triple<Pair<Integer, Integer>, Pair<Integer, Integer>, List<Pair<Integer, Integer>>> layout = GenericMenu.layoutSlots(handler.getSlots());
        this.width = (Integer)((Pair)layout.getLeft()).getLeft();
        this.height = (Integer)((Pair)layout.getLeft()).getRight();
        this.invX = (Integer)((Pair)layout.getMiddle()).getLeft();
        this.invY = (Integer)((Pair)layout.getMiddle()).getRight();
        this.slotList = (List)layout.getRight();
        for (int i = 0; i < this.slotList.size(); ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, i, ((Integer)this.slotList.get(i).getLeft()).intValue(), ((Integer)this.slotList.get(i).getRight()).intValue()));
        }
        this.layoutPlayerInventorySlots((Integer)((Pair)layout.getMiddle()).getLeft(), (Integer)((Pair)layout.getMiddle()).getRight());
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int inventorySize = this.slotList.size();
            int playerInventoryEnd = inventorySize + 27;
            int playerHotBarEnd = playerInventoryEnd + 9;
            if (index >= inventorySize) {
                if (!this.m_38903_(stack, 0, inventorySize, false)) {
                    return ItemStack.f_41583_;
                }
                if (index < playerInventoryEnd ? !this.m_38903_(stack, playerInventoryEnd, playerHotBarEnd, false) : index < playerHotBarEnd && !this.m_38903_(stack, inventorySize, playerInventoryEnd, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(stack, inventorySize, playerHotBarEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public static void open(ServerPlayer player, final IItemHandlerModifiable inventory, final Component name, final @Nullable ResourceLocation validatorId) {
        MenuProvider provider = new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return name;
            }

            public AbstractContainerMenu m_7208_(int containerId, @Nonnull Inventory inv, @Nonnull Player player) {
                BiPredicate<Integer, ItemStack> validator;
                if (validators.containsKey(validatorId == null ? EMPTY_VALIDATOR : validatorId)) {
                    validator = validators.get(validatorId);
                } else {
                    LibX.logger.warn("Generic container created with invalid validator. Validator ID: " + validatorId);
                    validator = validators.get(EMPTY_VALIDATOR);
                }
                return new GenericMenu(containerId, new GenericContainerSlotValidationWrapper(inventory, validator, null), inv);
            }
        };
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)provider, buffer -> {
            buffer.m_130130_(inventory.getSlots());
            buffer.m_130085_(validatorId == null ? EMPTY_VALIDATOR : validatorId);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                buffer.m_130130_(inventory.getSlotLimit(i));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSlotValidator(ResourceLocation validatorId, BiPredicate<Integer, ItemStack> validator) {
        Map<ResourceLocation, BiPredicate<Integer, ItemStack>> map = validators;
        synchronized (map) {
            if (validators.containsKey(validatorId)) {
                throw new IllegalStateException("Slot validator for generic container registered: " + validatorId);
            }
            validators.put(validatorId, validator);
        }
    }

    private static Triple<Pair<Integer, Integer>, Pair<Integer, Integer>, List<Pair<Integer, Integer>>> layoutSlots(int size) {
        if (size < 9) {
            return GenericMenu.layoutRectangle(size, 1, size);
        }
        if (size % 9 == 0 && size <= 72) {
            return GenericMenu.layoutRectangle(9, size / 9, size);
        }
        if (size % 11 == 0 && size <= 88) {
            return GenericMenu.layoutRectangle(11, size / 11, size);
        }
        if (size % 12 == 0 && size <= 96) {
            return GenericMenu.layoutRectangle(12, size / 12, size);
        }
        if (size % 8 == 0 && size <= 64) {
            return GenericMenu.layoutRectangle(8, size / 8, size);
        }
        if (size % 13 == 0 && size <= 104) {
            return GenericMenu.layoutRectangle(13, size / 13, size);
        }
        if (size % 14 == 0 && size <= 112) {
            return GenericMenu.layoutRectangle(14, size / 14, size);
        }
        if (size <= 72) {
            return GenericMenu.layoutRectangle(9, size % 9 == 0 ? size / 9 : size / 9 + 1, size);
        }
        if (size <= 88) {
            return GenericMenu.layoutRectangle(11, size % 11 == 0 ? size / 11 : size / 11 + 1, size);
        }
        if (size <= 96) {
            return GenericMenu.layoutRectangle(12, size % 12 == 0 ? size / 12 : size / 12 + 1, size);
        }
        if (size <= 104) {
            return GenericMenu.layoutRectangle(13, size % 13 == 0 ? size / 13 : size / 13 + 1, size);
        }
        return GenericMenu.layoutRectangle(14, size % 14 == 0 ? size / 14 : size / 14 + 1, size);
    }

    private static Triple<Pair<Integer, Integer>, Pair<Integer, Integer>, List<Pair<Integer, Integer>>> layoutRectangle(int width, int height, int maxSize) {
        int paddingX;
        int invX;
        if (width < 9) {
            invX = 0;
            paddingX = (9 - width) * 9;
        } else {
            invX = (width - 9) * 9;
            paddingX = 0;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (y * width + x >= maxSize) continue;
                builder.add((Object)Pair.of((Object)(7 + paddingX + 18 * x + 1), (Object)(17 + 18 * y + 1)));
            }
        }
        return Triple.of((Object)Pair.of((Object)Math.max(2 * (7 + invX) + 162, 2 * (7 + paddingX) + width * 18), (Object)(17 + 18 * height + 14 + 83)), (Object)Pair.of((Object)(7 + invX + 1), (Object)(17 + height * 18 + 14 + 1)), (Object)builder.build());
    }
}

