/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod;

import io.github.noeppi_noeppi.libx.annotation.meta.RemoveIn;
import io.github.noeppi_noeppi.libx.impl.ModInternal;
import io.github.noeppi_noeppi.libx.impl.config.ModMappers;
import io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ModX {
    public final String modid;
    public final Logger logger;
    @Nullable
    public final CreativeModeTab tab;

    protected ModX() {
        this(null);
    }

    protected ModX(@Nullable CreativeModeTab tab) {
        Class<?> cls = this.getClass();
        Mod mod = cls.getAnnotation(Mod.class);
        if (mod == null) {
            throw new IllegalStateException("Mod class has no @Mod annotation.");
        }
        this.modid = mod.value();
        this.logger = LogManager.getLogger((String)this.modid);
        this.tab = tab;
        ModInternal.init(this, FMLJavaModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        ModMappers.get(this.modid).initAdapter(ModLoadingContext.get());
        if (!(this instanceof ModXRegistration)) {
            ModInternal.get(this).callGeneratedCode();
        }
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.18")
    protected ModX(String modid, @Nullable CreativeModeTab tab) {
        this(tab);
    }

    protected abstract void setup(FMLCommonSetupEvent var1);

    protected abstract void clientSetup(FMLClientSetupEvent var1);

    public final ResourceLocation resource(String path) {
        return new ResourceLocation(this.modid, path);
    }
}

