/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import io.github.noeppi_noeppi.libx.LibX;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class RenderHelper {
    public static final ResourceLocation TEXTURE_WHITE = LibX.getInstance().resource("textures/white.png");
    private static final ResourceLocation TEXTURE_CHEST_GUI = new ResourceLocation("minecraft", "textures/gui/container/generic_54.png");

    public static void repeatBlit(PoseStack poseStack, int x, int y, int displayWidth, int displayHeight, TextureAtlasSprite sprite) {
        RenderHelper.repeatBlit(poseStack, x, y, sprite.m_118405_(), sprite.m_118408_(), displayWidth, displayHeight, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public static void repeatBlit(PoseStack ms, int x, int y, int texWidth, int texHeight, int displayWidth, int displayHeight, TextureAtlasSprite sprite) {
        RenderHelper.repeatBlit(ms, x, y, texWidth, texHeight, displayWidth, displayHeight, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public static void repeatBlit(PoseStack ms, int x, int y, int texWidth, int texHeight, int displayWidth, int displayHeight, float minU, float maxU, float minV, float maxV) {
        int pixelsNowX;
        for (int pixelsRenderedX = 0; pixelsRenderedX < displayWidth; pixelsRenderedX += pixelsNowX) {
            int pixelsNowY;
            pixelsNowX = Math.min(texWidth, displayWidth - pixelsRenderedX);
            float maxUThisTime = maxU;
            if (pixelsNowX < texWidth) {
                maxUThisTime = minU + (maxU - minU) * ((float)pixelsNowX / (float)texWidth);
            }
            for (int pixelsRenderedY = 0; pixelsRenderedY < displayHeight; pixelsRenderedY += pixelsNowY) {
                pixelsNowY = Math.min(texHeight, displayHeight - pixelsRenderedY);
                float maxVThisTime = maxV;
                if (pixelsNowY < texHeight) {
                    maxVThisTime = minV + (maxV - minV) * ((float)pixelsNowY / (float)texHeight);
                }
                GuiComponent.m_93112_((Matrix4f)ms.m_85850_().m_85861_(), (int)(x + pixelsRenderedX), (int)(x + pixelsRenderedX + pixelsNowX), (int)(y + pixelsRenderedY), (int)(y + pixelsRenderedY + pixelsNowY), (int)0, (float)minU, (float)maxUThisTime, (float)minV, (float)maxVThisTime);
            }
        }
    }

    public static void renderIconColored(PoseStack poseStack, VertexConsumer buffer, float x, float y, TextureAtlasSprite sprite, float width, float height, float alpha, int color, int light, int overlay) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(pose, x, y + height, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(pose, x + width, y + height, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(pose, x + width, y, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(pose, x, y, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void rgb(int color) {
        RenderSystem.m_157429_((float)((float)(color >>> 16 & 0xFF) / 255.0f), (float)((float)(color >>> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
    }

    public static void argb(int color) {
        RenderSystem.m_157429_((float)((float)(color >>> 16 & 0xFF) / 255.0f), (float)((float)(color >>> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24 & 0xFF) / 255.0f));
    }

    public static void resetColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderText(String text, PoseStack poseStack) {
        float widthHalf = (float)Minecraft.m_91087_().f_91062_.m_92895_(text) / 2.0f;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        float heightHalf = 9.0f / 2.0f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)(-(widthHalf + 2.0f)), (double)(-(heightHalf + 2.0f)), 0.0);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_WHITE);
        RenderSystem.m_157429_((float)0.2f, (float)0.2f, (float)0.2f, (float)0.8f);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)((int)(2.0f * widthHalf) + 4), (int)((int)(2.0f * heightHalf) + 4), (int)256, (int)256);
        RenderHelper.resetColor();
        RenderSystem.m_69461_();
        poseStack.m_85837_((double)(widthHalf + 2.0f), (double)(heightHalf + 2.0f), 10.0);
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, text, -widthHalf, -heightHalf, 0xFFFFFF);
        poseStack.m_85849_();
    }

    public static void renderGuiBackground(PoseStack poseStack, int x, int y, int width, int height) {
        RenderHelper.renderGuiBackground(poseStack, x, y, width, height, TEXTURE_CHEST_GUI);
    }

    public static void renderGuiBackground(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation texture) {
        RenderHelper.renderGuiBackground(poseStack, x, y, width, height, texture, 176, 222, 7, 169, 125, 139);
    }

    public static void renderGuiBackground(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation texture, int textureX, int textureY, int minU, int maxU, int minV, int maxV) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderHelper.repeatBlit(poseStack, x + 2, y + 2, maxU - minU, maxV - minV, width - 4, height - 4, (float)minU / 256.0f, (float)maxU / 256.0f, (float)minV / 256.0f, (float)maxV / 256.0f);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)4, (int)4, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + width - 5), (int)y, (int)0, (float)(textureX - 4), (float)0.0f, (int)4, (int)4, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)(y + height - 5), (int)0, (float)0.0f, (float)(textureY - 4), (int)4, (int)4, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)(x + width - 5), (int)(y + height - 5), (int)0, (float)(textureX - 4), (float)(textureY - 4), (int)4, (int)4, (int)256, (int)256);
        RenderHelper.repeatBlit(poseStack, x + 4, y, 169, 3, width - 8, 3, 0.015625f, (float)(textureX - 3) / 256.0f, 0.0f, 0.01171875f);
        RenderHelper.repeatBlit(poseStack, x + 4, y + height - 4, 169, 3, width - 8, 3, 0.015625f, (float)(textureX - 3) / 256.0f, (float)(textureY - 3) / 256.0f, (float)textureY / 256.0f);
        RenderHelper.repeatBlit(poseStack, x, y + 4, 3, 214, 3, height - 8, 0.0f, 0.01171875f, 0.015625f, (float)(textureY - 4) / 256.0f);
        RenderHelper.repeatBlit(poseStack, x + width - 4, y + 4, 3, 214, 3, height - 8, (float)(textureX - 3) / 256.0f, (float)textureX / 256.0f, 0.015625f, (float)(textureY - 4) / 256.0f);
    }
}

