/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;

public class LazyImmutableMap<K, V>
implements Map<K, V> {
    private final ImmutableMap<K, LazyValue<V>> map;
    private final LazyValue<Collection<V>> values;
    private final LazyValue<Set<Map.Entry<K, V>>> entries;

    public LazyImmutableMap(ImmutableMap<K, LazyValue<V>> map) {
        this.map = map;
        this.values = new LazyValue<Collection>(() -> (Collection)map.values().stream().map(LazyValue::get).collect(ImmutableList.toImmutableList()));
        this.entries = new LazyValue<Set>(() -> (Set)map.entrySet().stream().map(e -> Pair.of(e.getKey(), ((LazyValue)e.getValue()).get())).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        for (LazyValue lazy : this.map.values()) {
            if (!lazy.get().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return (V)((LazyValue)this.map.get(key)).get();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.values.get();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries.get();
    }
}

