/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class NbtToText {
    private static final HoverEvent COPY_NBT = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("libx.misc.copy_nbt"));

    public static MutableComponent toText(Tag nbt) {
        Style copyTag = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, nbt.toString())).m_131144_(COPY_NBT);
        return NbtToText.toTextInternal(nbt).m_130948_(copyTag);
    }

    private static MutableComponent toTextInternal(Tag nbt) {
        Tag tc;
        if (nbt instanceof EndTag) {
            return new TextComponent("");
        }
        Tag tag = nbt;
        if (tag instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)tag;
            tc = new TextComponent("{");
            List keys = tag2.m_128431_().stream().sorted().collect(Collectors.toList());
            for (int i = 0; i < keys.size(); ++i) {
                if (NbtToText.quotesRequired((String)keys.get(i))) {
                    tc = tc.m_7220_((Component)new TextComponent("\""));
                }
                tc = tc.m_7220_((Component)new TextComponent(NbtToText.escape((String)keys.get(i))).m_130940_(ChatFormatting.AQUA));
                tc = NbtToText.quotesRequired((String)keys.get(i)) ? tc.m_7220_((Component)new TextComponent("\": ")) : tc.m_7220_((Component)new TextComponent(": "));
                tc = tc.m_7220_((Component)NbtToText.toTextInternal(tag2.m_128423_((String)keys.get(i))));
                if (i + 1 >= keys.size()) continue;
                tc = tc.m_7220_((Component)new TextComponent(", "));
            }
            tc = tc.m_7220_((Component)new TextComponent("}"));
            return tc;
        }
        tc = nbt;
        if (tc instanceof ListTag) {
            ListTag tag3 = (ListTag)tc;
            tc = new TextComponent("[");
            for (int i = 0; i < tag3.size(); ++i) {
                tc = tc.m_7220_((Component)NbtToText.toTextInternal(tag3.get(i)));
                if (i + 1 >= tag3.size()) continue;
                tc = tc.m_7220_((Component)new TextComponent(", "));
            }
            tc = tc.m_7220_((Component)new TextComponent("]"));
            return tc;
        }
        tc = nbt;
        if (tc instanceof ByteTag) {
            ByteTag tag4 = (ByteTag)tc;
            return new TextComponent(Integer.toString(tag4.m_7063_())).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("b").m_130940_(ChatFormatting.RED));
        }
        tc = nbt;
        if (tc instanceof DoubleTag) {
            DoubleTag tag5 = (DoubleTag)tc;
            return new TextComponent(Double.toString(tag5.m_7061_())).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("d").m_130940_(ChatFormatting.RED));
        }
        tc = nbt;
        if (tc instanceof FloatTag) {
            FloatTag tag6 = (FloatTag)tc;
            return new TextComponent(Float.toString(tag6.m_7057_())).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("f").m_130940_(ChatFormatting.RED));
        }
        tc = nbt;
        if (tc instanceof IntTag) {
            IntTag tag7 = (IntTag)tc;
            return new TextComponent(Integer.toString(tag7.m_7047_())).m_130940_(ChatFormatting.GOLD);
        }
        tc = nbt;
        if (tc instanceof LongTag) {
            LongTag tag8 = (LongTag)tc;
            return new TextComponent(Long.toString(tag8.m_7046_())).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("l").m_130940_(ChatFormatting.RED));
        }
        tc = nbt;
        if (tc instanceof ShortTag) {
            ShortTag tag9 = (ShortTag)tc;
            return new TextComponent(Integer.toString(tag9.m_7053_())).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("s").m_130940_(ChatFormatting.RED));
        }
        tc = nbt;
        if (tc instanceof StringTag) {
            StringTag tag10 = (StringTag)tc;
            return new TextComponent("\"").m_7220_((Component)new TextComponent(NbtToText.escape(tag10.m_7916_())).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("\""));
        }
        tc = nbt;
        if (tc instanceof ByteArrayTag) {
            ByteArrayTag tag11 = (ByteArrayTag)tc;
            tc = new TextComponent("[");
            tc = tc.m_7220_((Component)new TextComponent("B").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tc = tc.m_7220_((Component)new TextComponent("; "));
            for (int i = 0; i < tag11.size(); ++i) {
                tc = tc.m_7220_((Component)NbtToText.toTextInternal((Tag)tag11.get(i)));
                if (i + 1 >= tag11.size()) continue;
                tc = tc.m_7220_((Component)new TextComponent(", "));
            }
            tc = tc.m_7220_((Component)new TextComponent("]"));
            return tc;
        }
        tc = nbt;
        if (tc instanceof IntArrayTag) {
            IntArrayTag tag12 = (IntArrayTag)tc;
            tc = new TextComponent("[");
            tc = tc.m_7220_((Component)new TextComponent("I").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tc = tc.m_7220_((Component)new TextComponent("; "));
            for (int i = 0; i < tag12.size(); ++i) {
                tc = tc.m_7220_((Component)NbtToText.toTextInternal((Tag)tag12.get(i)));
                if (i + 1 >= tag12.size()) continue;
                tc = tc.m_7220_((Component)new TextComponent(", "));
            }
            tc = tc.m_7220_((Component)new TextComponent("]"));
            return tc;
        }
        tc = nbt;
        if (tc instanceof LongArrayTag) {
            LongArrayTag tag13 = (LongArrayTag)tc;
            tc = new TextComponent("[");
            tc = tc.m_7220_((Component)new TextComponent("L").m_130940_(ChatFormatting.LIGHT_PURPLE));
            tc = tc.m_7220_((Component)new TextComponent("; "));
            for (int i = 0; i < tag13.size(); ++i) {
                tc = tc.m_7220_((Component)NbtToText.toTextInternal((Tag)tag13.get(i)));
                if (i + 1 >= tag13.size()) continue;
                tc = tc.m_7220_((Component)new TextComponent(", "));
            }
            tc = tc.m_7220_((Component)new TextComponent("]"));
            return tc;
        }
        throw new IllegalArgumentException("NBT type unknown: " + nbt.getClass());
    }

    private static boolean quotesRequired(String text) {
        for (char chr : text.toCharArray()) {
            if (Character.isLetterOrDigit(chr) || chr == '_') continue;
            return true;
        }
        return false;
    }

    private static String escape(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\\n").replace("\t", "\\\t").replace("\r", "\\\r").replace("\u0000", "\\\u0000").replace("\f", "\\\f");
    }
}

