/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.handler;

import com.blakebr0.pickletweaks.compat.curios.CuriosCompat;
import com.blakebr0.pickletweaks.feature.item.NightVisionGogglesItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public final class NightVisionGogglesHandler {
    public static final List<String> WEARERS = new ArrayList<String>();

    public static String getPlayerKey(Player player) {
        return player.m_36316_().getName() + ":" + player.f_19853_.f_46443_;
    }

    public static boolean hasGoggles(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
        return !stack.m_41619_() && stack.m_41720_() instanceof NightVisionGogglesItem || ModList.get().isLoaded("curios") && CuriosCompat.findNightVisionGogglesCurio((LivingEntity)player).isPresent();
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String key = NightVisionGogglesHandler.getPlayerKey(player);
            boolean hasGoggles = NightVisionGogglesHandler.hasGoggles(player);
            if (WEARERS.contains(key)) {
                if (hasGoggles) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 246, 0, true, false));
                } else {
                    player.m_6234_(MobEffects.f_19611_);
                    WEARERS.remove(key);
                }
            } else if (hasGoggles) {
                WEARERS.add(key);
            }
        }
    }
}

