/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.crafting.TagMapper;
import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessTagRecipe
extends ShapelessRecipe {
    private final String tag;
    private final int count;
    private ItemStack output;

    public ShapelessTagRecipe(ResourceLocation id, String group, NonNullList<Ingredient> inputs, String tag, int count) {
        super(id, group, ItemStack.f_41583_, inputs);
        this.tag = tag;
        this.count = count;
    }

    public ItemStack m_8043_() {
        if (this.output == null) {
            this.output = TagMapper.getItemStackForTag(this.tag, this.count);
        }
        return this.output;
    }

    public boolean m_5598_() {
        if (this.output == null) {
            this.output = TagMapper.getItemStackForTag(this.tag, this.count);
        }
        return this.output.m_41619_();
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.CRAFTING_SHAPED_TAG;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessTagRecipe> {
        public ShapelessTagRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            String tag = GsonHelper.m_13906_((JsonObject)result, (String)"tag");
            int count = GsonHelper.m_13824_((JsonObject)result, (String)"count", (int)1);
            return new ShapelessTagRecipe(recipeId, group, ingredients, tag, count);
        }

        public ShapelessTagRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int size = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            String tag = buffer.m_130277_();
            int count = buffer.m_130242_();
            return new ShapelessTagRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, tag, count);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessTagRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130070_(recipe.tag);
            buffer.m_130130_(recipe.count);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

