/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.feature.crafting.GridRepairHelper;
import com.blakebr0.pickletweaks.init.ModRecipeSerializers;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class GridRepairRecipe
extends ShapelessRecipe {
    public GridRepairRecipe(ResourceLocation id) {
        super(id, "", ItemStack.f_41583_, NonNullList.m_122779_());
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        if (!((Boolean)ModConfigs.GRID_REPAIR_ENABLED.get()).booleanValue()) {
            return ItemStack.f_41583_;
        }
        ItemStack tool = ItemStack.f_41583_;
        NonNullList inputs = NonNullList.m_122779_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack slotStack = inv.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            if (tool.m_41619_() && slotStack.m_41763_()) {
                tool = slotStack;
                continue;
            }
            inputs.add((Object)slotStack);
        }
        if (tool.m_41619_() || !tool.m_41768_() || inputs.isEmpty()) {
            return ItemStack.f_41583_;
        }
        if (GridRepairHelper.isBlacklisted(tool.m_41720_())) {
            return ItemStack.f_41583_;
        }
        int repairCost = (Integer)ModConfigs.GRID_REPAIR_COST.get();
        int enchantmentCost = (Integer)ModConfigs.GRID_REPAIR_ENCHANTMENT_COST.get();
        boolean cheaperShovel = (Boolean)ModConfigs.GRID_REPAIR_CHEAP_SHOVEL.get();
        boolean cheaperShears = (Boolean)ModConfigs.GRID_REPAIR_CHEAP_SHEARS.get();
        if (cheaperShovel && tool.m_41720_() instanceof ShovelItem || cheaperShears && tool.m_41720_() instanceof ShearsItem) {
            repairCost = Math.max(1, repairCost / 2);
            enchantmentCost = Math.max(0, enchantmentCost / 2);
        }
        int damage = tool.m_41776_() / (repairCost + (tool.m_41793_() ? enchantmentCost : 0));
        double matCount = 0.0;
        boolean maxed = false;
        for (ItemStack mat : inputs) {
            if (maxed) {
                return ItemStack.f_41583_;
            }
            if (!mat.hasCraftingRemainingItem()) {
                double matValue = GridRepairHelper.getMaterialValue(tool, mat);
                if (matValue == 0.0) {
                    return ItemStack.f_41583_;
                }
                matCount += matValue;
                if (!((double)tool.m_41773_() - (double)damage * matCount <= 0.0)) continue;
                maxed = true;
                continue;
            }
            return ItemStack.f_41583_;
        }
        tool = StackHelper.withSize((ItemStack)tool, (int)1, (boolean)false);
        tool.m_41721_(tool.m_41773_() - (int)((double)damage * matCount));
        if (((Boolean)ModConfigs.GRID_REPAIR_STRIP_ENCHANTMENTS.get()).booleanValue()) {
            Map<Enchantment, Integer> enchantments = EnchantmentHelper.m_44831_((ItemStack)tool).entrySet().stream().filter(x -> ((Enchantment)x.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            EnchantmentHelper.m_44865_(enchantments, (ItemStack)tool);
        }
        return tool;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        return !this.m_5874_(inv).m_41619_();
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_GRID_REPAIR.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public static class Serializer
    implements RecipeSerializer<GridRepairRecipe> {
        public GridRepairRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new GridRepairRecipe(recipeId);
        }

        public GridRepairRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new GridRepairRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, GridRepairRecipe recipe) {
        }
    }
}

