/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.tweaks;

import com.blakebr0.cucumber.event.ScytheHarvestCropEvent;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class TweakToolBreaking {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (stack.m_41763_() && TweakToolBreaking.isValidTool(item) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (stack.m_41763_() && TweakToolBreaking.isValidTool(item) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAttackEntity(AttackEntityEvent event) {
        Item item;
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41763_() && TweakToolBreaking.isValidTool(item = stack.m_41720_()) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (stack.m_41763_() && (item instanceof ProjectileWeaponItem || item instanceof ShearsItem) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (stack.m_41763_() && (item instanceof ShovelItem || item instanceof AxeItem || item instanceof HoeItem) && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (stack.m_41763_() && item instanceof ShearsItem && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onScytheHarvestCrop(ScytheHarvestCropEvent event) {
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41763_() && TweakToolBreaking.isBroken(stack)) {
            TweakToolBreaking.sendBrokenMessage(player, stack);
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item;
        if (!((Boolean)ModConfigs.ENABLE_TOOL_BREAKING_TWEAK.get()).booleanValue()) {
            return;
        }
        ListIterator<MutableComponent> tooltip = event.getToolTip().listIterator();
        ItemStack stack = event.getItemStack();
        if (stack.m_41763_() && (TweakToolBreaking.isValidTool(item = stack.m_41720_()) || item instanceof ProjectileWeaponItem) && TweakToolBreaking.isBroken(stack)) {
            tooltip.next();
            tooltip.add(ModTooltips.BROKEN.color(ChatFormatting.RED).build());
        }
    }

    public static boolean isValidTool(Item item) {
        return item instanceof DiggerItem || item instanceof SwordItem || item instanceof ShearsItem;
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41776_() > 2 && stack.m_41773_() >= stack.m_41776_() - 2;
    }

    private static void sendBrokenMessage(Player player, ItemStack stack) {
        player.m_5661_((Component)ModTooltips.YOUR_ITEM_IS_BROKEN.args(new Object[]{stack.m_41786_()}).color(ChatFormatting.WHITE).build(), true);
    }
}

