/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.bell;

import io.github.noeppi_noeppi.mods.villagersoctober.ModItems;
import io.github.noeppi_noeppi.mods.villagersoctober.advancement.ModTriggers;
import io.github.noeppi_noeppi.mods.villagersoctober.bell.BellHelper;
import io.github.noeppi_noeppi.mods.villagersoctober.villager.ModMemories;
import io.github.noeppi_noeppi.mods.villagersoctober.villager.VillagerBrainHelper;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class GiveCandyBehavior
extends Behavior<Villager> {
    private Player player;
    private Vec3 target;
    private int candyTimer;
    private ItemStack candyStack;

    public GiveCandyBehavior() {
        super(Map.of(ModMemories.candyTarget, MemoryStatus.VALUE_PRESENT), 240);
    }

    protected void start(@Nonnull ServerLevel level, @Nonnull Villager entity, long gameTime) {
        Player player = entity.m_6274_().m_21952_(ModMemories.candyTarget).orElse(null);
        if (player == null) {
            this.player = null;
            this.target = null;
            this.candyTimer = 0;
        } else {
            this.player = player;
            this.target = player.m_20182_();
            this.candyTimer = 0;
            if (entity.m_5803_()) {
                entity.m_5796_();
            }
            VillagerBrainHelper.navigate(entity, this.target, 0.5);
        }
    }

    protected void tick(@Nonnull ServerLevel level, @Nonnull Villager owner, long gameTime) {
        if (this.player == null || this.target == null) {
            return;
        }
        if (this.candyTimer <= 0) {
            if (this.target.m_82557_(owner.m_20182_()) <= 2.25) {
                VillagerBrainHelper.stay(owner);
                this.candyTimer = 1;
            } else if (owner.m_21573_().m_26577_() || !owner.m_21573_().m_26572_()) {
                this.target = this.player.m_20182_();
                VillagerBrainHelper.navigate(owner, this.target, 0.5);
            }
        } else {
            if (this.candyTimer > 60) {
                this.player = null;
                this.target = null;
                this.candyTimer = 0;
                this.candyStack = null;
                return;
            }
            ++this.candyTimer;
        }
        if (this.candyTimer > 0) {
            VillagerBrainHelper.stay(owner);
            if (this.candyStack == null) {
                Random random = new Random();
                this.candyStack = new ItemStack((ItemLike)ModItems.candy.random(random), 1 + random.nextInt(2));
            }
            owner.m_21391_((Entity)this.player, 20.0f, 20.0f);
            if (this.candyTimer < 40) {
                owner.m_21008_(InteractionHand.MAIN_HAND, this.candyStack.m_41777_());
            } else {
                owner.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            if (this.candyTimer == 40) {
                BehaviorUtils.m_22613_((LivingEntity)owner, (ItemStack)this.candyStack.m_41777_(), (Vec3)this.player.m_20182_());
                BellHelper.setCandyTimer(owner);
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModTriggers.HALLOWEEN.trigger(serverPlayer, (Entity)owner, this.candyStack.m_41777_());
                }
                owner.m_6274_().m_21936_(ModMemories.candyTarget);
                owner.m_6274_().m_21889_(Activity.f_37982_);
            }
        }
    }

    protected void stop(@Nonnull ServerLevel level, @Nonnull Villager entity, long gameTime) {
        this.player = null;
        this.target = null;
        this.candyTimer = 0;
        this.candyStack = null;
        entity.m_6274_().m_21936_(ModMemories.candyTarget);
        entity.m_6274_().m_21889_(Activity.f_37982_);
    }

    protected boolean canStillUse(@Nonnull ServerLevel level, @Nonnull Villager entity, long gameTime) {
        return this.player != null && this.target != null;
    }
}

