/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.bloon;

import io.github.noeppi_noeppi.mods.villagersoctober.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class GhastBalloon
extends Entity {
    public static final double MAX_TIE_LENGTH = 6.0;
    private static final EntityDataAccessor<BlockPos> TIE_POS = SynchedEntityData.m_135353_(GhastBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Float> LOOK_ANGLE = SynchedEntityData.m_135353_(GhastBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private BlockPos tiePos = BlockPos.f_121853_;
    private Vec3 tieVec;
    private float targetLookAngle;
    private int ticksWithoutFence = 0;

    public GhastBalloon(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BlockPos getTiePos() {
        return this.tiePos;
    }

    @Nullable
    public Vec3 getTieVec() {
        return this.tieVec;
    }

    public void setTiePos(BlockPos tiePos) {
        this.tiePos = tiePos.m_7949_();
        this.tieVec = new Vec3((double)tiePos.m_123341_() + 0.5, (double)tiePos.m_123342_() + 0.65, (double)tiePos.m_123343_() + 0.5);
        this.f_19804_.m_135381_(TIE_POS, (Object)this.tiePos);
    }

    public void setLookAngle(float angle) {
        this.setLookAngleDeg((float)Math.toDegrees(angle));
    }

    public void setLookAngleDeg(float angle) {
        this.targetLookAngle = Mth.m_14177_((float)angle);
        if (!this.isAddedToWorld() && !this.f_19853_.f_46443_) {
            this.m_146922_(this.targetLookAngle);
        }
        this.f_19804_.m_135381_(LOOK_ANGLE, (Object)Float.valueOf(this.targetLookAngle));
    }

    public boolean m_6094_() {
        return !this.m_213877_();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        if (super.m_6673_(source)) {
            return true;
        }
        return source.m_146707_() || source == DamageSource.f_19311_;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        if (amount > 0.0f) {
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_5993_((Entity)this, 0, source);
            }
            this.die();
        }
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.tieVec != null) {
            Vec3 tieVec = this.m_20182_().m_82505_(this.tieVec);
            if (tieVec.m_82556_() > 81.0) {
                double l = tieVec.m_82553_();
                double f = (l - 6.0) / l;
                this.m_146884_(this.m_20182_().m_82549_(tieVec.m_82541_().m_82542_(f, f, f)));
                this.m_20256_(Vec3.f_82478_);
            } else {
                double zm;
                Vec3 velocity = this.m_20184_();
                double xm = velocity.f_82479_ == 0.0 ? (this.f_19796_.m_188500_() - 0.5) * 0.05 : velocity.f_82479_ * 0.9;
                double ym = velocity.f_82480_ == 0.0 ? 0.01 : velocity.f_82480_;
                double d = zm = velocity.f_82481_ == 0.0 ? (this.f_19796_.m_188500_() - 0.5) * 0.05 : velocity.f_82481_ * 0.9;
                if (tieVec.m_82556_() < 36.0) {
                    ym += 0.05;
                } else {
                    double tension = (tieVec.m_82553_() - 6.0) / 6.0 * 0.15;
                    ym -= tension;
                }
                if (tieVec.f_82479_ * tieVec.f_82479_ + tieVec.f_82481_ * tieVec.f_82481_ > 0.4) {
                    xm += tieVec.f_82479_ * 0.04;
                    zm += tieVec.f_82481_ * 0.04;
                }
                this.m_20334_((3.0 * velocity.f_82479_ + xm) / 4.0, (3.0 * velocity.f_82480_ + ym) / 4.0, (3.0 * velocity.f_82481_ + zm) / 4.0);
            }
        }
        float rotDiff = Mth.m_14177_((float)(this.targetLookAngle - this.m_146908_()));
        float newRot = this.m_146908_();
        if ((double)Math.abs(rotDiff) <= 0.5) {
            if (!this.f_19853_.f_46443_) {
                this.findNewLookTarget();
            }
        } else {
            float rotChange = Mth.m_14036_((float)rotDiff, (float)-2.0f, (float)2.0f);
            newRot = Mth.m_14177_((float)(newRot + rotChange));
        }
        this.m_146867_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_146922_(newRot);
        Vec3 position = this.m_20182_();
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.pushEntities();
        if (!this.f_19853_.f_46443_ && this.isAddedToWorld() && this.f_19853_.isAreaLoaded(this.m_20183_(), 1) && this.tieVec != null) {
            if (this.m_20186_() < this.tieVec.f_82480_ || !this.f_19853_.m_8055_(this.tiePos).m_204336_(BlockTags.f_13039_)) {
                ++this.ticksWithoutFence;
                if (this.ticksWithoutFence >= 8) {
                    this.die();
                }
            } else {
                this.ticksWithoutFence = 0;
            }
        }
    }

    private void die() {
        if (!this.f_19853_.f_46443_) {
            this.m_19998_((ItemLike)ModItems.ghastBalloon);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void pushEntities() {
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
        for (Entity entity : entities) {
            entity.m_7334_((Entity)this);
        }
    }

    private void findNewLookTarget() {
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_(10.0, 20.0, 10.0), e -> e instanceof LivingEntity && !e.m_5833_());
        Entity closest = null;
        double horDistanceSqr = Double.POSITIVE_INFINITY;
        for (Entity entity : entities) {
            double zDiff;
            double xDiff = entity.m_20185_() - this.m_20185_();
            double distSqr = xDiff * xDiff + (zDiff = entity.m_20189_() - this.m_20189_()) * zDiff;
            if (!(distSqr < horDistanceSqr)) continue;
            closest = entity;
            horDistanceSqr = distSqr;
        }
        if (closest != null) {
            double xDiff = closest.m_20185_() - this.m_20185_();
            double zDiff = closest.m_20189_() - this.m_20189_();
            this.setLookAngle((float)(Math.atan2(zDiff, xDiff) - 1.5707963267948966));
        } else {
            this.setLookAngleDeg(this.m_146908_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIE_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(LOOK_ANGLE, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TIE_POS.equals(key) && this.f_19853_.f_46443_) {
            this.setTiePos((BlockPos)this.f_19804_.m_135370_(TIE_POS));
        } else if (LOOK_ANGLE.equals(key) && this.f_19853_.f_46443_) {
            this.setLookAngleDeg(((Float)this.f_19804_.m_135370_(LOOK_ANGLE)).floatValue());
        }
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected PortalInfo m_7937_(@Nonnull ServerLevel level) {
        return null;
    }

    protected void m_7378_(@Nonnull CompoundTag nbt) {
        this.setTiePos(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("TiePos")));
        this.setLookAngleDeg(nbt.m_128457_("TargetLookAngle"));
    }

    protected void m_7380_(@Nonnull CompoundTag nbt) {
        nbt.m_128365_("TiePos", (Tag)NbtUtils.m_129224_((BlockPos)this.tiePos));
        nbt.m_128350_("TargetLookAngle", this.targetLookAngle);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.ghastBalloon);
    }
}

