/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.core;

import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureTracker {
    private static final ThreadLocal<StructureData> CURRENT_STRUCTURE = new ThreadLocal();

    public static void startStructure(StructureStart start, WorldGenLevel level) {
        CURRENT_STRUCTURE.remove();
        RegistryAccess registries = level.m_5962_();
        Structure structure = start.m_226861_();
        Registry structureRegistry = registries.m_142664_(Registry.f_235725_).orElse(null);
        Registry structureSetRegistry = registries.m_142664_(Registry.f_211073_).orElse(null);
        if (structureRegistry == null || structureSetRegistry == null) {
            return;
        }
        ResourceKey structureKey = structureRegistry.m_7854_((Object)structure).orElse(null);
        if (structureKey == null) {
            return;
        }
        StructureSet villages = structureSetRegistry.m_123009_(BuiltinStructureSets.f_209820_).orElse(null);
        boolean isVillage = villages != null && villages.f_210003_().stream().anyMatch(sel -> sel.f_210026_().m_203565_(structureKey));
        CURRENT_STRUCTURE.set(new StructureData((ResourceKey<Structure>)structureKey, isVillage));
    }

    public static void endStructure() {
        CURRENT_STRUCTURE.remove();
    }

    @Nullable
    public static StructureData get() {
        return CURRENT_STRUCTURE.get();
    }

    record StructureData(ResourceKey<Structure> structure, boolean isVillage) {
    }
}

