/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.data;

import io.github.noeppi_noeppi.mods.villagersoctober.ModBlocks;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.datagen.provider.BlockStateProviderBase;
import org.moddingx.libx.mod.ModX;

public class BlockStates
extends BlockStateProviderBase {
    public BlockStates(ModX mod, DataGenerator generator, ExistingFileHelper fileHelper) {
        super(mod, generator, fileHelper);
    }

    protected void setup() {
        this.manualState((Block)ModBlocks.doorbell);
        this.manualModel((Block)ModBlocks.mysticalTable);
        this.manualModel((Block)ModBlocks.garland);
        this.makeDoorbell((Block)ModBlocks.doorbell);
        this.makeScarecrow((Block)ModBlocks.scarecrow, ModBlocks.scarecrowTop);
    }

    private void makeDoorbell(Block block) {
        ResourceLocation id = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
        ModelFile.ExistingModelFile base = this.models().getExistingFile(this.mod.resource("block/" + id.m_135815_()));
        ModelFile.ExistingModelFile pressed = this.models().getExistingFile(this.mod.resource("block/" + id.m_135815_() + "_pressed"));
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (Direction direction : BlockStateProperties.f_61374_.m_6908_()) {
            builder.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)direction).with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)base, 0, (int)direction.m_122424_().m_122435_(), false)});
            builder.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)direction).with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressed, 0, (int)direction.m_122424_().m_122435_(), false)});
        }
    }

    private void makeScarecrow(Block block, Block topBlock) {
        for (int i = 0; i <= 5; ++i) {
            ResourceLocation tex = i == 0 ? new ResourceLocation("minecraft", "block/carved_pumpkin") : this.mod.resource("block/scarecrow_face_" + i);
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("scarecrow_" + i, this.mod.resource("block/scarecrow"))).texture("face", tex);
            if (i != 0) continue;
            this.manualModel(block, (ModelFile)model);
        }
        ResourceLocation topId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)topBlock));
        this.manualModel(topBlock, (ModelFile)((BlockModelBuilder)this.models().getBuilder(topId.m_135815_())).texture("particle", new ResourceLocation("minecraft", "block/hay_block_side")));
    }
}

