/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.garland;

import io.github.noeppi_noeppi.mods.villagersoctober.ModBlocks;
import io.github.noeppi_noeppi.mods.villagersoctober.util.BlockClipHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.moddingx.libx.base.tile.BlockEntityBase;

public class Garland
extends BlockEntityBase {
    private static final Direction[] HORIZONTAL_DIRS = new Direction[]{Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST};
    private boolean primary = false;
    private BlockPos otherPos = BlockPos.f_121853_;
    private AABB renderAABB;
    private boolean generating = false;
    private int maxDownGenerating = 2;

    public Garland(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.updateRenderAABB();
    }

    public boolean primary() {
        return this.primary;
    }

    public BlockPos otherPos() {
        return this.otherPos;
    }

    public boolean generateOnLoad() {
        return this.generating;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
        this.m_6596_();
        this.setDispatchable();
    }

    public void setOtherPos(BlockPos otherPos) {
        this.otherPos = otherPos.m_7949_();
        this.m_6596_();
        this.setDispatchable();
    }

    public void setGenerateOnLoad(int maxDown) {
        this.primary = false;
        this.otherPos = BlockPos.f_121853_;
        this.updateRenderAABB();
        this.generating = true;
        this.maxDownGenerating = Math.min(maxDown, 2);
        this.m_6596_();
    }

    public void onLoad() {
        super.onLoad();
        if (this.generating) {
            boolean generated = false;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.m_58900_().m_61138_((Property)BlockStateProperties.f_61374_)) {
                BlockEntity blockEntity;
                List positions;
                BlockPos pos;
                HashMap<BlockPos, BlockState> possiblePositions = new HashMap<BlockPos, BlockState>();
                int minX = this.f_58858_.m_123341_() - 14;
                int maxX = this.f_58858_.m_123341_() + 14;
                int minY = this.f_58858_.m_123342_() - Math.min(2, this.maxDownGenerating);
                int maxY = this.f_58858_.m_123342_() + 3;
                int minZ = this.f_58858_.m_123343_() - 14;
                int maxZ = this.f_58858_.m_123343_() + 14;
                Direction currentDir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
                switch (currentDir) {
                    case NORTH: {
                        minZ = this.f_58858_.m_123343_() + 5;
                        break;
                    }
                    case SOUTH: {
                        maxZ = this.f_58858_.m_123343_() - 5;
                        break;
                    }
                    case WEST: {
                        minX = this.f_58858_.m_123341_() + 5;
                        break;
                    }
                    case EAST: {
                        maxX = this.f_58858_.m_123341_() - 5;
                    }
                }
                BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        block8: for (int z = minZ; z <= maxZ; ++z) {
                            mpos.m_122178_(x, y, z);
                            if (!this.f_58857_.m_46859_((BlockPos)mpos)) continue;
                            for (Direction dir : HORIZONTAL_DIRS) {
                                BlockState state;
                                if (dir == currentDir || !(state = (BlockState)ModBlocks.garland.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir)).m_60710_((LevelReader)this.f_58857_, (BlockPos)mpos) || !BlockClipHelper.isFreeSpace(this.f_58857_, this.f_58858_, (BlockPos)mpos)) continue;
                                possiblePositions.put(mpos.m_7949_(), state);
                                continue block8;
                            }
                        }
                    }
                }
                Random random = new Random(Mth.m_14057_((Vec3i)this.f_58858_) + 42L);
                if (possiblePositions.isEmpty()) {
                    int targetHeight = this.f_58858_.m_123342_() + 1 + random.nextInt(2);
                    for (int i = 0; i < 5; ++i) {
                        int z;
                        int x = minX + random.nextInt(maxX - minX + 1);
                        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos(x, targetHeight, z = minZ + random.nextInt(maxZ - minZ + 1));
                        if (!BlockClipHelper.isFreeSpace(this.f_58857_, this.f_58858_, (BlockPos)target) || !this.f_58857_.m_46859_((BlockPos)target) || !this.f_58857_.m_46859_(target.m_6625_(1)) || !this.f_58857_.m_46859_(target.m_6625_(2))) continue;
                        this.f_58857_.m_7731_((BlockPos)target, Blocks.f_50705_.m_49966_(), 3);
                        if (random.nextInt(3) == 0) {
                            this.f_58857_.m_7731_(target.m_7494_(), (BlockState)Blocks.f_50144_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.m_122407_((int)random.nextInt(4))), 3);
                        }
                        BlockPos.MutableBlockPos mt = target.m_122032_().m_122184_(0, -1, 0);
                        while ((this.f_58857_.m_46859_((BlockPos)mt) || this.f_58857_.m_8055_((BlockPos)mt).m_60767_().m_76336_() || this.f_58857_.m_8055_((BlockPos)mt).m_204336_(BlockTags.f_13073_)) && this.f_58857_.m_7731_((BlockPos)mt, Blocks.f_50132_.m_49966_(), 3)) {
                            mt.m_122184_(0, -1, 0);
                        }
                        possiblePositions.put(target.m_121945_(currentDir), (BlockState)ModBlocks.garland.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)currentDir.m_122424_()));
                        break;
                    }
                }
                if (!possiblePositions.isEmpty() && this.f_58857_.m_7731_(pos = (BlockPos)(positions = possiblePositions.keySet().stream().toList()).get(random.nextInt(positions.size())), (BlockState)possiblePositions.get(pos), 3) && (blockEntity = this.f_58857_.m_7702_(pos)) instanceof Garland) {
                    Garland garland = (Garland)blockEntity;
                    generated = true;
                    garland.setPrimary(false);
                    garland.setOtherPos(this.f_58858_);
                    this.setPrimary(true);
                    this.setOtherPos(pos);
                }
            }
            this.generating = false;
            this.maxDownGenerating = 2;
            this.m_6596_();
            if (generated) {
                this.setDispatchable();
            } else if (this.f_58857_ != null) {
                this.f_58857_.m_46961_(this.f_58858_, false);
            }
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.primary = nbt.m_128471_("Primary");
        this.otherPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("OtherPos")).m_7949_();
        this.generating = nbt.m_128471_("GenerateOnLoad");
        this.maxDownGenerating = nbt.m_128451_("GenerateOnLoadMaxDownBy");
        this.updateRenderAABB();
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Primary", this.primary);
        nbt.m_128365_("OtherPos", (Tag)NbtUtils.m_129224_((BlockPos)this.otherPos));
        nbt.m_128379_("GenerateOnLoad", this.generating);
        nbt.m_128405_("GenerateOnLoadMaxDownBy", this.maxDownGenerating);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            nbt.m_128379_("Primary", this.primary);
            nbt.m_128365_("OtherPos", (Tag)NbtUtils.m_129224_((BlockPos)this.otherPos));
        }
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.primary = nbt.m_128471_("Primary");
            this.otherPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("OtherPos")).m_7949_();
            this.updateRenderAABB();
        }
    }

    private void updateRenderAABB() {
        int minX = Math.min(this.f_58858_.m_123341_(), this.otherPos.m_123341_());
        int maxX = Math.max(this.f_58858_.m_123341_() + 1, this.otherPos.m_123341_() + 1);
        int minY = Math.min(this.f_58858_.m_123342_() - 4, this.otherPos.m_123342_() - 4);
        int maxY = Math.max(this.f_58858_.m_123342_() + 1, this.otherPos.m_123342_() + 1);
        int minZ = Math.min(this.f_58858_.m_123343_(), this.otherPos.m_123343_());
        int maxZ = Math.max(this.f_58858_.m_123343_() + 1, this.otherPos.m_123343_() + 1);
        this.renderAABB = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).m_82400_(1.0);
    }

    public AABB getRenderBoundingBox() {
        return this.renderAABB;
    }
}

