/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.scarecrow;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;

public class Scarecrow
extends BlockEntityBase
implements TickingBlock {
    private int hitCount;
    private int animationTime;
    private double animationAngle;

    public Scarecrow(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void tick() {
        if (this.animationTime > 0) {
            --this.animationTime;
            if (this.animationTime == 0) {
                this.hitCount = 0;
                this.animationAngle = 0.0;
            }
            this.m_6596_();
        }
    }

    public boolean hit(Player player) {
        if (this.hitCount++ >= 5) {
            this.m_6596_();
            return true;
        }
        this.hitFrom(player.m_20182_());
        return false;
    }

    public void hitFrom(Vec3 vec) {
        this.animationTime = 80;
        double xDiff = (double)this.f_58858_.m_123341_() + 0.5 - vec.f_82479_;
        double zDiff = (double)this.f_58858_.m_123343_() + 0.5 - vec.f_82481_;
        this.animationAngle = Math.atan2(xDiff, zDiff);
        this.m_6596_();
        this.setDispatchable();
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public double getAnimationAngle() {
        return this.animationAngle;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.hitCount = nbt.m_128451_("HitCount");
        this.animationTime = nbt.m_128451_("AnimationTime");
        this.animationAngle = nbt.m_128459_("AnimationAngle");
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("HitCount", this.hitCount);
        nbt.m_128405_("AnimationTime", this.animationTime);
        nbt.m_128347_("AnimationAngle", this.animationAngle);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            nbt.m_128405_("AnimationTime", this.animationTime);
            nbt.m_128347_("AnimationAngle", this.animationAngle);
        }
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.animationTime = nbt.m_128451_("AnimationTime");
            this.animationAngle = nbt.m_128459_("AnimationAngle");
        }
    }
}

