/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.structure;

import io.github.noeppi_noeppi.mods.villagersoctober.structure.TemplateHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;

public class DebugDecorator {
    public static void decorate(WorldGenLevel level, ResourceKey<Structure> structure, StructureTemplate template, StructurePlaceSettings oldSettings, BlockPos at, BlockPos at2) {
        StructurePlaceSettings settings = oldSettings.m_74374_();
        settings.m_74394_();
        settings.m_230324_(null);
        StructureTemplate.Palette palette = settings.m_74387_(template.f_74482_, at);
        HashMap<BlockPos, List<ItemStack>> stackMap = new HashMap<BlockPos, List<ItemStack>>();
        for (StructureTemplate.StructureBlockInfo block : TemplateHelper.processBlockInfos((LevelAccessor)level, at, at2, settings, palette.m_74652_(), template)) {
            DebugDecorator.addBlockDebug(level, block, stackMap);
        }
        DebugDecorator.placeBlockDebug(level, stackMap);
    }

    private static void addBlockDebug(WorldGenLevel level, StructureTemplate.StructureBlockInfo block, Map<BlockPos, List<ItemStack>> stackMap) {
        if (block.f_74676_.m_60795_()) {
            return;
        }
        BlockPos pos = block.f_74675_.m_7949_();
        if (level.m_46859_(block.f_74675_)) {
            return;
        }
        if (level.m_8055_(block.f_74675_).m_60734_() == Blocks.f_50618_) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("title", "Block Info - " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_());
        nbt.m_128359_("author", "Minecraft");
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("T: " + DebugDecorator.stateStr(block.f_74676_) + "\nW: " + DebugDecorator.stateStr(level.m_8055_(pos)) + "\nU+Y: " + DebugDecorator.stateStr(level.m_8055_(pos.m_7494_())) + "\nD-Y: " + DebugDecorator.stateStr(level.m_8055_(pos.m_7495_())) + "\nE+X: " + DebugDecorator.stateStr(level.m_8055_(pos.m_122029_())) + "\nW-X: " + DebugDecorator.stateStr(level.m_8055_(pos.m_122024_())) + "\nS+Z: " + DebugDecorator.stateStr(level.m_8055_(pos.m_122019_())) + "\nN-Z: " + DebugDecorator.stateStr(level.m_8055_(pos.m_122012_())));
        int counter = 0;
        StringBuilder current = new StringBuilder();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    if (!current.isEmpty()) {
                        current.append("\n");
                    }
                    String id = (x > 0 ? "+" : "") + x + (y > 0 ? "+" : "") + y + (z >= 0 ? "+" : "") + z;
                    current.append(id).append(": ").append(DebugDecorator.stateStr(level.m_8055_(pos.m_7918_(x, y, z))));
                    if (++counter < 7) continue;
                    counter = 0;
                    lines.add(current.toString());
                    current = new StringBuilder();
                }
            }
        }
        if (!current.isEmpty()) {
            lines.add(current.toString());
        }
        ListTag list = new ListTag();
        lines.forEach(l -> list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)l)))));
        nbt.m_128365_("pages", (Tag)list);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42615_);
        stack.m_41751_(nbt);
        stackMap.computeIfAbsent(pos, k -> new ArrayList()).add(stack);
    }

    private static String stateStr(BlockState state) {
        ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (rl == null) {
            return "UNKNOWN";
        }
        StringBuilder sb = new StringBuilder();
        if (!rl.m_135827_().equals("minecraft")) {
            sb.append(rl.m_135827_()).append(":");
        }
        sb.append(rl.m_135815_());
        if (!state.m_61147_().isEmpty()) {
            sb.append("[");
            boolean first = true;
            for (Property prop : state.m_61147_()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(prop.m_61708_().charAt(0)).append("=");
                Comparable value = state.m_61143_(prop);
                if (value instanceof Direction) {
                    Direction dir = (Direction)value;
                    sb.append(dir.name().toUpperCase(Locale.ROOT).charAt(0));
                    continue;
                }
                if (value instanceof Direction.Axis) {
                    Direction.Axis axis = (Direction.Axis)value;
                    sb.append(axis.name().toUpperCase(Locale.ROOT).charAt(0));
                    continue;
                }
                String valueStr = value.toString();
                sb.append(valueStr.isEmpty() ? "?" : valueStr.substring(0, 1));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static void placeBlockDebug(WorldGenLevel level, Map<BlockPos, List<ItemStack>> stackMap) {
        for (Map.Entry<BlockPos, List<ItemStack>> entry : stackMap.entrySet()) {
            level.m_7731_(entry.getKey(), Blocks.f_50618_.m_49966_(), 3);
            BlockEntity blockEntity = level.m_7702_(entry.getKey());
            if (blockEntity instanceof BarrelBlockEntity) {
                BarrelBlockEntity chest = (BarrelBlockEntity)blockEntity;
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    chest.m_6836_(i, entry.getValue().get(i).m_41777_());
                }
                continue;
            }
            level.m_7731_(entry.getKey(), Blocks.f_50090_.m_49966_(), 3);
        }
    }
}

