/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.structure;

import io.github.noeppi_noeppi.mods.villagersoctober.ModBlocks;
import io.github.noeppi_noeppi.mods.villagersoctober.ModItems;
import io.github.noeppi_noeppi.mods.villagersoctober.bloon.GhastBalloon;
import io.github.noeppi_noeppi.mods.villagersoctober.garland.Garland;
import io.github.noeppi_noeppi.mods.villagersoctober.structure.TemplateHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.moddingx.libx.util.lazy.LazyValue;

public class VillageDecorator {
    public static void decorate(WorldGenLevel level, ResourceKey<Structure> structure, StructureTemplate template, StructurePlaceSettings oldSettings, BlockPos at, BlockPos at2) {
        StructurePlaceSettings settings = oldSettings.m_74374_();
        settings.m_74394_();
        settings.m_230324_(null);
        StructureTemplate.Palette palette = settings.m_74387_(template.f_74482_, at);
        Random random = new Random(Mth.m_14057_((Vec3i)at) ^ ((long)"Villager".hashCode() << 32 | (long)"October".hashCode()));
        boolean hasScarecrow = false;
        LazyValue templateCenter = new LazyValue(() -> {
            BoundingBox box = template.m_74633_(settings, at);
            return new BlockPos(Math.round((float)(box.m_162399_() - box.m_162395_()) / 2.0f), Math.round((float)(box.m_162400_() - box.m_162396_()) / 2.0f), Math.round((float)(box.m_162401_() - box.m_162398_()) / 2.0f));
        });
        for (StructureTemplate.StructureBlockInfo block : TemplateHelper.processBlockInfos((LevelAccessor)level, at, at2, settings, palette.m_74652_(), template)) {
            GhastBalloon balloon;
            Direction dir;
            if (!hasScarecrow && block.f_74676_.m_204336_(BlockTags.f_13073_) && random.nextInt(15) == 0 && level.m_8055_(block.f_74675_).m_204336_(BlockTags.f_13073_) && level.m_46859_(block.f_74675_.m_7494_())) {
                if (level.m_8055_(block.f_74675_.m_7495_()).m_60734_() == Blocks.f_50093_) {
                    level.m_7731_(block.f_74675_.m_7495_(), Blocks.f_50546_.m_49966_(), 3);
                }
                level.m_7731_(block.f_74675_, (BlockState)ModBlocks.scarecrow.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(random.nextInt(16))), 3);
                level.m_7731_(block.f_74675_.m_7494_(), ModBlocks.scarecrowTop.m_49966_(), 3);
                hasScarecrow = true;
            }
            if (block.f_74676_.m_204336_(BlockTags.f_13103_) && block.f_74676_.m_60734_() instanceof DoorBlock && block.f_74676_.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER && level.m_8055_(block.f_74675_).m_204336_(BlockTags.f_13103_)) {
                Direction firstLook;
                boolean inverseDoor = false;
                if (BuiltinStructures.f_209865_.equals(structure) && block.f_74676_.m_60734_() == Blocks.f_50486_) {
                    inverseDoor = true;
                }
                if (BuiltinStructures.f_209866_.equals(structure) && block.f_74676_.m_60734_() == Blocks.f_50487_) {
                    inverseDoor = true;
                }
                Direction facing = (Direction)block.f_74676_.m_61143_((Property)BlockStateProperties.f_61374_);
                if (inverseDoor) {
                    facing = facing.m_122424_();
                }
                BlockPos frontPos = block.f_74675_.m_121945_(facing.m_122424_());
                Direction direction = firstLook = block.f_74676_.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_();
                if (!VillageDecorator.tryPlaceBell(level, frontPos.m_121945_(firstLook), facing)) {
                    VillageDecorator.tryPlaceBell(level, frontPos.m_121945_(firstLook.m_122424_()), facing);
                }
            }
            if (block.f_74676_.m_204336_(BlockTags.f_13037_) && random.nextInt(4) == 0 && level.m_8055_(block.f_74675_).m_204336_(BlockTags.f_13037_) && level.m_46859_(block.f_74675_.m_121945_(dir = Direction.m_122407_((int)random.nextInt(4))))) {
                level.m_7731_(block.f_74675_, (BlockState)Blocks.f_50144_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir), 3);
            }
            if (block.f_74676_.m_204336_(BlockTags.f_13039_) && random.nextInt(40) == 0 && level.m_8055_(block.f_74675_).m_204336_(BlockTags.f_13039_) && level.m_46859_(block.f_74675_.m_6630_(1)) && level.m_46859_(block.f_74675_.m_6630_(2)) && level.m_46859_(block.f_74675_.m_6630_(3)) && (balloon = (GhastBalloon)ModItems.ghastBalloon.entityType.m_20615_((Level)level.m_6018_())) != null) {
                balloon.m_6034_((double)block.f_74675_.m_123341_() + 0.5, (double)block.f_74675_.m_123342_() + 2.6, (double)block.f_74675_.m_123343_() + 0.5);
                balloon.setLookAngleDeg(random.nextFloat() * 360.0f);
                balloon.setTiePos(block.f_74675_.m_7949_());
                VillageDecorator.trySpawnEntity(level, balloon);
            }
            if (block.f_74675_.m_123342_() - at.m_123342_() < 4 || random.nextInt(30) != 0) continue;
            int maxDown = Math.min(2, block.f_74675_.m_123342_() - at.m_123342_() - 4);
            int xd = block.f_74675_.m_123341_() - ((BlockPos)templateCenter.get()).m_123341_();
            int zd = block.f_74675_.m_123343_() - ((BlockPos)templateCenter.get()).m_123343_();
            Direction.Axis firstAxis = Math.abs(xd) > Math.abs(zd) ? Direction.Axis.X : Direction.Axis.Z;
            Direction.Axis secondAxis = firstAxis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction first = Direction.m_122387_((Direction.Axis)firstAxis, (Direction.AxisDirection)((firstAxis == Direction.Axis.X ? xd : zd) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            Direction second = Direction.m_122387_((Direction.Axis)secondAxis, (Direction.AxisDirection)((secondAxis == Direction.Axis.X ? xd : zd) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            if (VillageDecorator.tryPlaceGarland(level, block.f_74675_.m_121945_(first), first.m_122424_(), maxDown)) continue;
            VillageDecorator.tryPlaceGarland(level, block.f_74675_.m_121945_(second), second.m_122424_(), maxDown);
        }
    }

    private static boolean tryPlaceBell(WorldGenLevel level, BlockPos pos, Direction facing) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() == ModBlocks.doorbell) {
            return true;
        }
        if (!currentState.m_60795_() && currentState.m_60734_() != Blocks.f_50081_ && !currentState.m_204336_(BlockTags.f_13037_)) {
            return false;
        }
        if (!level.m_8055_(pos.m_121945_(facing)).m_60783_((BlockGetter)level, pos, facing.m_122424_())) {
            return false;
        }
        if (level.m_8055_(pos.m_121945_(facing)).m_204336_(BlockTags.f_13103_)) {
            return false;
        }
        BlockState state = (BlockState)ModBlocks.doorbell.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        return level.m_7731_(pos, state, 3);
    }

    private static boolean tryPlaceGarland(WorldGenLevel level, BlockPos pos, Direction facing, int maxDown) {
        BlockState currentState = level.m_8055_(pos);
        if (!currentState.m_60795_() && currentState.m_60734_() != Blocks.f_50081_ && !currentState.m_204336_(BlockTags.f_13037_)) {
            return false;
        }
        if (!level.m_8055_(pos.m_121945_(facing)).m_60783_((BlockGetter)level, pos, facing.m_122424_())) {
            return false;
        }
        if (level.m_8055_(pos.m_121945_(facing)).m_204336_(BlockTags.f_13103_)) {
            return false;
        }
        BlockState state = (BlockState)ModBlocks.garland.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        if (!level.m_7731_(pos, state, 3)) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Garland) {
            Garland garland = (Garland)blockEntity;
            garland.setGenerateOnLoad(maxDown);
            return true;
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        return false;
    }

    private static void trySpawnEntity(WorldGenLevel level, Entity entity) {
        if (level instanceof WorldGenRegion) {
            WorldGenRegion wgr = (WorldGenRegion)level;
            int x = (int)Math.floor(entity.m_20185_()) >> 4;
            int z = (int)Math.floor(entity.m_20189_()) >> 4;
            if (wgr.m_143488_().f_45578_ == x && wgr.m_143488_().f_45579_ == z) {
                level.m_7967_(entity);
            }
        } else {
            level.m_7967_(entity);
        }
    }
}

