/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.bloon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import io.github.noeppi_noeppi.mods.villagersoctober.bloon.GhastBalloon;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.moddingx.libx.render.RenderHelper;

public class GhastBalloonRenderer
extends EntityRenderer<GhastBalloon> {
    public static final float GHAST_SCALE = 0.33f;
    private ClientLevel level;
    private Ghast ghast;
    private EntityRenderer<Ghast> renderer;

    protected GhastBalloonRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
        this.f_114478_ = 0.0f;
    }

    private boolean updateState() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        if (this.level == null || this.level != Minecraft.m_91087_().f_91073_ || this.ghast == null || this.renderer == null) {
            this.level = Minecraft.m_91087_().f_91073_;
            this.ghast = new Ghast(EntityType.f_20453_, (Level)this.level);
            this.renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.ghast);
            return this.renderer != null;
        }
        return true;
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull GhastBalloon entity) {
        return RenderHelper.TEXTURE_WHITE;
    }

    public void render(@Nonnull GhastBalloon balloon, float entityYaw, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)balloon, entityYaw, partialTick, poseStack, buffer, light);
        if (this.updateState()) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.33f, 0.33f, 0.33f);
            this.ghast.m_146884_(balloon.m_20182_());
            this.ghast.f_19854_ = balloon.f_19854_;
            this.ghast.f_19855_ = balloon.f_19855_;
            this.ghast.f_19856_ = balloon.f_19856_;
            this.ghast.f_19790_ = balloon.f_19790_;
            this.ghast.f_19791_ = balloon.f_19791_;
            this.ghast.f_19792_ = balloon.f_19792_;
            this.ghast.m_146926_(balloon.m_146909_());
            this.ghast.m_146922_(balloon.m_146908_());
            this.ghast.f_19860_ = balloon.f_19860_;
            this.ghast.f_19859_ = balloon.f_19859_;
            this.ghast.f_20883_ = balloon.m_146908_();
            this.ghast.f_20884_ = balloon.f_19859_;
            this.ghast.f_19797_ = balloon.f_19797_;
            this.renderer.m_7392_((Entity)this.ghast, entityYaw, partialTick, poseStack, buffer, light);
            poseStack.m_85849_();
            this.renderLeash(balloon, partialTick, poseStack, buffer, light);
        }
    }

    private void renderLeash(GhastBalloon balloon, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        Vec3 leashTieVec = balloon.getTieVec();
        if (leashTieVec == null) {
            return;
        }
        poseStack.m_85836_();
        double balloonRot = (double)Mth.m_14179_((float)partialTicks, (float)balloon.f_19859_, (float)balloon.m_146908_()) * (Math.PI / 180) + 1.5707963267948966;
        Vec3 leashOffset = this.ghast.m_7939_().m_82542_((double)0.33f, (double)0.33f, (double)0.33f);
        double offX = Math.cos(balloonRot) * leashOffset.f_82481_ + Math.sin(balloonRot) * leashOffset.f_82479_;
        double offZ = Math.sin(balloonRot) * leashOffset.f_82481_ - Math.cos(balloonRot) * leashOffset.f_82479_;
        double dx = Mth.m_14139_((double)partialTicks, (double)balloon.f_19854_, (double)balloon.m_20185_()) + offX;
        double dy = Mth.m_14139_((double)partialTicks, (double)balloon.f_19855_, (double)balloon.m_20186_()) + leashOffset.f_82480_;
        double dz = Mth.m_14139_((double)partialTicks, (double)balloon.f_19856_, (double)balloon.m_20189_()) + offZ;
        poseStack.m_85837_(offX, leashOffset.f_82480_, offZ);
        float fx = (float)(leashTieVec.f_82479_ - dx);
        float fy = (float)(leashTieVec.f_82480_ - dy);
        float fz = (float)(leashTieVec.f_82481_ - dz);
        VertexConsumer vertex = buffer.m_6299_(RenderType.m_110475_());
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        float normFactor = Mth.m_14195_((float)(fx * fx + fz * fz)) * 0.025f / 2.0f;
        float nx = fx * normFactor;
        float nz = fz * normFactor;
        for (int i1 = 0; i1 <= 24; ++i1) {
            GhastBalloonRenderer.addVertexPair(vertex, pose, fx, fy, fz, light, nx, nz, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            GhastBalloonRenderer.addVertexPair(vertex, pose, fx, fy, fz, light, nx, nz, j1, true);
        }
        poseStack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer vertex, Matrix4f pose, float x, float y, float z, int light, float nx, float nz, int idx, boolean reverse) {
        float amount = (float)idx / 24.0f;
        float shade = idx % 2 == (reverse ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * shade;
        float g = 0.4f * shade;
        float b = 0.3f * shade;
        float xb = x * amount;
        float yb = y > 0.0f ? y * amount * amount : y - y * (1.0f - amount) * (1.0f - amount);
        float zb = z * amount;
        vertex.m_85982_(pose, xb - nz, yb + (reverse ? 0.0f : 0.025f), zb + nx).m_85950_(r, g, b, 1.0f).m_85969_(light).m_5752_();
        vertex.m_85982_(pose, xb + nz, yb + (reverse ? 0.025f : 0.0f), zb - nx).m_85950_(r, g, b, 1.0f).m_85969_(light).m_5752_();
    }
}

