/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.dress;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DressHelper {
    private static final List<Dress> dresses = new ArrayList<Dress>();

    public static boolean hasDress(Player player) {
        for (Dress dress : dresses) {
            if (!dress.hasDress(player)) continue;
            return true;
        }
        return false;
    }

    public static void addDress(@Nullable Item head, @Nullable Item chest) {
        DressHelper.addDress(head, chest, null, null);
    }

    public static void addDress(@Nullable Item head, @Nullable Item chest, @Nullable Item legs, @Nullable Item feet) {
        if (head == null && chest == null && legs == null && feet == null) {
            throw new IllegalArgumentException("Empty dress");
        }
        dresses.add(new Dress(head, chest, legs, feet));
    }

    private record Dress(@Nullable Item head, @Nullable Item chest, @Nullable Item legs, @Nullable Item feet) {
        public boolean hasDress(Player player) {
            ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
            if (this.head == null ? !head.m_41619_() : !head.m_150930_(this.head)) {
                return false;
            }
            if (this.chest == null ? !chest.m_41619_() : !chest.m_150930_(this.chest)) {
                return false;
            }
            if (this.legs == null ? !legs.m_41619_() : !legs.m_150930_(this.legs)) {
                return false;
            }
            return !(this.feet == null ? !feet.m_41619_() : !feet.m_150930_(this.feet));
        }
    }
}

