/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.dress.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import io.github.noeppi_noeppi.mods.villagersoctober.dress.DressItem;
import io.github.noeppi_noeppi.mods.villagersoctober.dress.render.DressRenderProperties;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DressLayer<M extends HumanoidModel<Player>>
extends RenderLayer<Player, M> {
    private final EquipmentSlot[] RENDER_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND};
    private final DressRenderProperties.RenderContext context = new DressRenderProperties.RenderContext(){

        @Override
        public void translateBy(PoseStack poseStack, EquipmentSlot slot, boolean left) {
            DressLayer.this.translateBy(poseStack, slot, left);
        }

        @Override
        public void translateTo(PoseStack poseStack, EquipmentSlot slot, boolean left) {
            DressLayer.this.translateTo(poseStack, slot, left);
        }
    };

    public DressLayer(RenderLayerParent<Player, M> renderer) {
        super(renderer);
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, @Nonnull Player entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderItem(poseStack, buffer, entity, light, EquipmentSlot.HEAD, partialTick);
        this.renderItem(poseStack, buffer, entity, light, EquipmentSlot.CHEST, partialTick);
        this.renderItem(poseStack, buffer, entity, light, EquipmentSlot.LEGS, partialTick);
        this.renderItem(poseStack, buffer, entity, light, EquipmentSlot.FEET, partialTick);
    }

    private void renderItem(PoseStack poseStack, MultiBufferSource buffer, Player entity, int light, EquipmentSlot slot, float partialTicks) {
        Item item;
        ItemStack stack = entity.m_6844_(slot);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof DressItem) {
            DressItem dress = (DressItem)item;
            if (slot == dress.slot) {
                DressRenderProperties properties = dress.getRenderProperties();
                for (EquipmentSlot renderSlot : this.RENDER_SLOTS) {
                    BakedModel model = properties.getModel(renderSlot);
                    if (model == null) continue;
                    this.renderModel(poseStack, buffer, stack, model, properties.getTargetRenderType(), renderSlot, light, false);
                    if (renderSlot != EquipmentSlot.LEGS && renderSlot != EquipmentSlot.FEET && renderSlot != EquipmentSlot.MAINHAND) continue;
                    this.renderModel(poseStack, buffer, stack, model, properties.getTargetRenderType(), renderSlot, light, true);
                }
                properties.renderCustom(this.context, poseStack, buffer, entity, stack, light, partialTicks);
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource buffer, ItemStack stack, BakedModel model, RenderType renderType, EquipmentSlot slot, int light, boolean left) {
        poseStack.m_85836_();
        this.translateTo(poseStack, slot, left);
        model.applyTransform(ItemTransforms.TransformType.HEAD, poseStack, slot != EquipmentSlot.FEET && slot != EquipmentSlot.LEGS && left);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertex = buffer.m_6299_(renderType);
        Minecraft.m_91087_().m_91291_().m_115189_(model, stack, light, OverlayTexture.f_118083_, poseStack, vertex);
        poseStack.m_85849_();
    }

    private void translateBy(PoseStack poseStack, EquipmentSlot slot, boolean left) {
        switch (slot) {
            case HEAD: {
                ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
                break;
            }
            case CHEST: {
                ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
                break;
            }
            case LEGS: 
            case FEET: {
                if (left) {
                    poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
                    ((HumanoidModel)this.m_117386_()).f_102814_.m_104299_(poseStack);
                    poseStack.m_85837_(-0.11875, -0.75, 0.0);
                    break;
                }
                ((HumanoidModel)this.m_117386_()).f_102813_.m_104299_(poseStack);
                poseStack.m_85837_(0.11875, -0.75, 0.0);
                break;
            }
            case MAINHAND: {
                if (left) {
                    ((HumanoidModel)this.m_117386_()).f_102812_.m_104299_(poseStack);
                    poseStack.m_85837_(-0.3125, -0.125, 0.0);
                    break;
                }
                ((HumanoidModel)this.m_117386_()).f_102811_.m_104299_(poseStack);
                poseStack.m_85837_(0.3125, -0.125, 0.0);
            }
        }
    }

    private void translateTo(PoseStack poseStack, EquipmentSlot slot, boolean left) {
        this.translateBy(poseStack, slot, left);
        poseStack.m_85837_(0.0, -0.25, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85841_(0.625f, -0.625f, -0.625f);
    }
}

