/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.villagersoctober.garland;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.noeppi_noeppi.mods.villagersoctober.ModItemTags;
import io.github.noeppi_noeppi.mods.villagersoctober.ModItems;
import io.github.noeppi_noeppi.mods.villagersoctober.garland.Garland;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.util.data.TagAccess;

public class GarlandRenderer
implements BlockEntityRenderer<Garland> {
    public static final double MIN_DIST_F = 1.0;
    public static final double MAX_DIST_F = 2.0;
    public static final double HEIGHT_FACTOR = 1.0;
    public static final double GARLAND_RADIUS = 0.1;
    public static final double ITEMS_PER_BLOCK = 0.5;
    private static final RenderType TARGET = RenderType.m_110446_((ResourceLocation)RenderHelper.TEXTURE_WHITE);
    private static final double SQRT_HALF = Math.sqrt(0.5);
    private static final Vec3 VEC_UP = new Vec3(0.0, 1.0, 0.0);

    public void render(@Nonnull Garland garland, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (!garland.primary() || garland.m_58904_() == null) {
            return;
        }
        Random random = new Random(Mth.m_14057_((Vec3i)garland.m_58899_()));
        int rgb = Color.HSBtoRGB(random.nextFloat(360.0f), 0.6f, 0.6f);
        float r = (float)(rgb >>> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >>> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        Level level = garland.m_58904_();
        Vec3 basePos = new Vec3((double)garland.m_58899_().m_123341_(), (double)garland.m_58899_().m_123342_(), (double)garland.m_58899_().m_123343_());
        Vec3 from = GarlandRenderer.getHangingPoint(garland.m_58900_(), garland.m_58899_());
        Vec3 to = GarlandRenderer.getHangingPoint(level.m_8055_(garland.otherPos()), garland.otherPos());
        double distance = from.m_82554_(to);
        int steps = (int)Math.round(distance * 2.0);
        Vec3 last = from.m_82546_(basePos);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        PoseStack.Pose pose = poseStack.m_85850_();
        VertexConsumer vertex = buffer.m_6299_(TARGET);
        Vec3[] offsetNormals = GarlandRenderer.getOffsetNormals(from, to);
        for (int i = 0; i < steps; ++i) {
            Vec3 current = i == steps - 1 ? to : GarlandRenderer.getRopePos(from, to, (double)(i + 1) / (double)steps);
            current = current.m_82546_(basePos);
            mpos.m_122169_(current.f_82479_, current.f_82480_, current.f_82481_);
            int stepLight = level.m_5518_().m_75831_((BlockPos)mpos, 0);
            stepLight = LightTexture.m_109885_((int)stepLight, (int)stepLight);
            this.connect(pose, vertex, stepLight, last, current, offsetNormals, r, g, b);
            last = current;
        }
        int items = (int)Math.max(3L, Math.round(distance * 0.5));
        TagAccess tags = TagAccess.create((Level)level);
        Quaternion alignRot = Vector3f.f_122225_.m_122270_((float)Math.atan2(to.f_82479_ - from.f_82479_, to.f_82481_ - from.f_82481_));
        for (int i = 0; i < items; ++i) {
            Vec3 pos = GarlandRenderer.getRopePos(from, to, (double)(i + 1) / (double)(items + 1));
            pos = pos.m_82546_(basePos);
            mpos.m_122169_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            int stepLight = level.m_5518_().m_75831_((BlockPos)mpos, 0);
            stepLight = LightTexture.m_109885_((int)stepLight, (int)stepLight);
            this.renderItem(random, tags, poseStack, buffer, stepLight, pos, alignRot);
        }
    }

    private void connect(PoseStack.Pose pose, VertexConsumer vertex, int light, Vec3 last, Vec3 current, Vec3[] offsetNormals, float r, float g, float b) {
        for (int i = 0; i < 4; ++i) {
            Vec3 off1 = offsetNormals[i];
            Vec3 off2 = offsetNormals[(i + 1) % 4];
            Vec3 normal = offsetNormals[i + 4];
            vertex.m_85982_(pose.m_85861_(), (float)(last.f_82479_ + off1.f_82479_), (float)(last.f_82480_ + off1.f_82480_), (float)(last.f_82481_ + off1.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(last.f_82479_ + off2.f_82479_), (float)(last.f_82480_ + off2.f_82480_), (float)(last.f_82481_ + off2.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(current.f_82479_ + off2.f_82479_), (float)(current.f_82480_ + off2.f_82480_), (float)(current.f_82481_ + off2.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(current.f_82479_ + off1.f_82479_), (float)(current.f_82480_ + off1.f_82480_), (float)(current.f_82481_ + off1.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(current.f_82479_ + off1.f_82479_), (float)(current.f_82480_ + off1.f_82480_), (float)(current.f_82481_ + off1.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(current.f_82479_ + off2.f_82479_), (float)(current.f_82480_ + off2.f_82480_), (float)(current.f_82481_ + off2.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(last.f_82479_ + off2.f_82479_), (float)(last.f_82480_ + off2.f_82480_), (float)(last.f_82481_ + off2.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            vertex.m_85982_(pose.m_85861_(), (float)(last.f_82479_ + off1.f_82479_), (float)(last.f_82480_ + off1.f_82480_), (float)(last.f_82481_ + off1.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(pose.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        }
    }

    private void renderItem(Random random, TagAccess tags, PoseStack poseStack, MultiBufferSource buffer, int light, Vec3 off, Quaternion alignRot) {
        Item item = random.nextBoolean() ? (Item)ModItems.candy.random(random) : tags.random(ModItemTags.GARLAND_ITEMS, RandomSource.m_216335_((long)random.nextLong())).orElse(Items.f_42127_);
        ItemStack stack = new ItemStack((ItemLike)item);
        poseStack.m_85836_();
        poseStack.m_85837_(off.f_82479_, off.f_82480_ - 0.1, off.f_82481_);
        poseStack.m_85845_(alignRot);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        if (stack.m_204117_(ItemTags.f_13149_)) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        } else {
            poseStack.m_85837_(0.0, -0.5, 0.0);
        }
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, 0);
        poseStack.m_85849_();
    }

    private static Vec3 getHangingPoint(BlockState state, BlockPos pos) {
        Direction dir = Direction.UP;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        double xOff = 0.5;
        double zOff = 0.5;
        if (dir.m_122434_() == Direction.Axis.X) {
            double d = xOff = dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 0.8125 : 0.1875;
        }
        if (dir.m_122434_() == Direction.Axis.Z) {
            zOff = dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 0.8125 : 0.1875;
        }
        return new Vec3((double)pos.m_123341_() + xOff, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + zOff);
    }

    private static Vec3 getRopePos(Vec3 from, Vec3 to, double pct) {
        double dstFactor = Mth.m_14139_((double)(from.m_82554_(to) / 20.0), (double)1.0, (double)2.0);
        double maxValue = 1.0 * Math.cosh(dstFactor);
        double value = 1.0 * Math.cosh(dstFactor * (pct * 2.0 - 1.0)) - maxValue;
        double linearHeight = Mth.m_14139_((double)pct, (double)from.f_82480_, (double)to.f_82480_);
        return new Vec3(Mth.m_14139_((double)pct, (double)from.f_82479_, (double)to.f_82479_), linearHeight + value, Mth.m_14139_((double)pct, (double)from.f_82481_, (double)to.f_82481_));
    }

    private static Vec3[] getOffsetNormals(Vec3 from, Vec3 to) {
        Vec3 n1 = new Vec3(from.f_82481_ - to.f_82481_, 0.0, to.f_82479_ - from.f_82479_).m_82541_();
        return new Vec3[]{n1.m_82490_(SQRT_HALF).m_82549_(VEC_UP.m_82490_(SQRT_HALF)).m_82490_(0.1), n1.m_82490_(-SQRT_HALF).m_82549_(VEC_UP.m_82490_(SQRT_HALF)).m_82490_(0.1), n1.m_82490_(-SQRT_HALF).m_82549_(VEC_UP.m_82490_(-SQRT_HALF)).m_82490_(0.1), n1.m_82490_(SQRT_HALF).m_82549_(VEC_UP.m_82490_(-SQRT_HALF)).m_82490_(0.1), VEC_UP, n1.m_82490_(-1.0), VEC_UP.m_82490_(-1.0), n1};
    }
}

