/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.menu.BlockMenu;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class MenuBlock<C extends BlockMenu>
extends BlockBase {
    public final MenuType<C> menu;

    public MenuBlock(ModX mod, MenuType<C> menu, BlockBehaviour.Properties properties) {
        this(mod, menu, properties, new Item.Properties());
    }

    public MenuBlock(ModX mod, MenuType<C> menu, BlockBehaviour.Properties properties, @Nullable Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.menu = menu;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        super.registerAdditional(ctx, builder);
        builder.register(Registry.f_122913_, this.menu);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initTracking(RegistrationContext ctx, Registerable.TrackingCollector builder) throws ReflectiveOperationException {
        super.initTracking(ctx, builder);
        builder.track(ForgeRegistries.MENU_TYPES, MenuBlock.class.getDeclaredField("menu"));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockMenu.openMenu(sp, this.menu, (Component)Component.m_237115_((String)("screen." + this.mod.modid + "." + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this)).m_135815_())), pos);
        }
        return InteractionResult.SUCCESS;
    }
}

