/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli.content;

import java.util.List;
import javax.annotation.Nullable;
import org.moddingx.libx.annotation.meta.Experimental;
import org.moddingx.libx.datagen.provider.patchouli.content.TextContent;
import org.moddingx.libx.datagen.provider.patchouli.page.Content;
import org.moddingx.libx.datagen.provider.patchouli.page.PageBuilder;
import org.moddingx.libx.datagen.provider.patchouli.page.PageJson;

@Experimental
public abstract class CaptionContent
implements Content {
    @Nullable
    protected final String caption;

    protected CaptionContent(@Nullable String caption) {
        this.caption = caption;
    }

    protected abstract int lineSkip();

    protected abstract CaptionContent withCaption(String var1);

    protected abstract void specialPage(PageBuilder var1, @Nullable String var2);

    protected boolean canTakeRegularText() {
        return false;
    }

    @Override
    public void pages(PageBuilder builder) {
        List<String> pages;
        List<String> list = pages = this.caption == null ? List.of() : PageJson.splitText(this.caption, this.lineSkip());
        if (pages.isEmpty()) {
            this.specialPage(builder, null);
        } else if (pages.size() == 1) {
            this.specialPage(builder, (String)pages.get(0));
        } else {
            this.specialPage(builder, (String)pages.get(0));
            TextContent.addTextPages(builder, pages, false);
        }
    }

    @Override
    public Content with(Content next) {
        if (next instanceof TextContent) {
            TextContent tc = (TextContent)next;
            if (this.canTakeRegularText() || tc.caption()) {
                return this.withCaption((String)(this.caption == null ? tc.text() : this.caption + " " + tc.text()));
            }
        }
        return Content.super.with(next);
    }
}

