/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.editor;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.EditorOps;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.impl.config.gui.EditorHelper;
import org.moddingx.libx.screen.Panel;

public class OptionEditor<T>
implements ConfigEditor<Optional<T>> {
    private final ConfigEditor<T> editor;

    public OptionEditor(ConfigEditor<T> editor) {
        this.editor = editor;
    }

    @Override
    public Optional<T> defaultValue() {
        return Optional.empty();
    }

    @Override
    public AbstractWidget createWidget(Screen screen, Optional<T> initialValue, WidgetProperties<Optional<T>> properties) {
        return new OptionWidget<T>(screen, this.editor, initialValue, properties);
    }

    @Override
    public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<Optional<T>> properties) {
        if (old instanceof OptionWidget) {
            return new OptionWidget<T>(screen, this.editor, (OptionWidget)old, properties);
        }
        return this.createWidget(screen, (Optional<T>)this.defaultValue(), properties);
    }

    private static class OptionWidget<T>
    extends Panel {
        private final Consumer<Optional<T>> inputChanged;
        private final Checkbox box;
        private final AbstractWidget widget;
        private T value;

        private OptionWidget(Screen screen, ConfigEditor<T> editor, WidgetProperties<Optional<T>> properties, T value, boolean selected, @Nullable AbstractWidget old) {
            super(screen, properties.x() - 22, properties.y(), properties.width() + 22, properties.height());
            this.inputChanged = properties.inputChanged();
            this.value = value;
            this.box = new Checkbox(0, 0, 20, Math.min(20, properties.height()), (Component)Component.m_237119_(), selected, false){

                public void m_5691_() {
                    super.m_5691_();
                    EditorOps.wrap((Widget)widget).enabled(this.m_93840_());
                    this.update(null);
                }
            };
            WidgetProperties<Object> modified = new WidgetProperties<Object>(22, 0, properties.width(), properties.height(), this::update);
            this.widget = EditorHelper.create(screen, editor, this.value, old, modified);
            EditorOps.wrap((Widget)this.widget).enabled(selected);
            this.addRenderableWidget(this.box);
            this.addRenderableWidget(this.widget);
        }

        public OptionWidget(Screen screen, ConfigEditor<T> editor, Optional<T> initialValue, WidgetProperties<Optional<T>> properties) {
            this(screen, editor, properties, initialValue.orElse(editor.defaultValue()), initialValue.isPresent(), null);
        }

        public OptionWidget(Screen screen, ConfigEditor<T> editor, OptionWidget<T> old, WidgetProperties<Optional<T>> properties) {
            this(screen, editor, properties, old.value, old.box.m_93840_(), old.widget);
        }

        private void update(@Nullable T t) {
            if (t != null) {
                this.value = t;
            }
            this.inputChanged.accept(this.box.m_93840_() ? Optional.of(this.value) : Optional.empty());
        }

        @Override
        public void enabled(boolean enabled) {
            EditorOps.wrap((Widget)this.box).enabled(enabled);
        }
    }
}

