/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.glyphs.SpecialGlyphs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.LibX;

public class FontLoader {
    private static StringSplitter.WidthProvider widthProvider;

    public static StringSplitter.WidthProvider getFontWidthProvider(@Nullable ExistingFileHelper fileHelper) {
        if (widthProvider == null) {
            if (fileHelper == null) {
                throw new RuntimeException("Can't load font without file helper.");
            }
            try {
                byte[] sizes;
                Resource res = fileHelper.getResource(new ResourceLocation("minecraft", "font/glyph_sizes.bin"), PackType.CLIENT_RESOURCES);
                try (InputStream in = res.m_215507_();){
                    sizes = in.readAllBytes();
                }
                widthProvider = (codePoint, style) -> {
                    if (codePoint >= 0 && codePoint < sizes.length) {
                        byte data = sizes[codePoint];
                        if (data == 0) {
                            return 0.0f;
                        }
                        return (data & 0xF) - (data >> 4 & 0xF) + 1;
                    }
                    return SpecialGlyphs.MISSING.m_83827_(style.m_131154_());
                };
            }
            catch (IOException e) {
                LibX.logger.error("Failed to load glyph sizes during datagen. Using Missing glyph provider.", (Throwable)e);
                widthProvider = (codePoint, style) -> SpecialGlyphs.MISSING.m_83827_(style.m_131154_());
            }
        }
        return widthProvider;
    }
}

